/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.csv;

import org.apache.jena.atlas.csv.CSVTokenType;
import org.apache.jena.atlas.lib.Lib;

class CSVToken {
    final CSVTokenType type;
    final String image;
    final long line;
    final long col;

    public boolean same(CSVToken obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.type != obj.type) {
            return false;
        }
        if (this.type == CSVTokenType.COMMA || this.type == CSVTokenType.NL || this.type == CSVTokenType.EOF) {
            return true;
        }
        if (this.image == null && obj.image != null) {
            return false;
        }
        return Lib.equal(this.image, obj.image);
    }

    public CSVToken(long line, long col, CSVTokenType type, String image) {
        this.type = type;
        this.image = image;
        this.line = line;
        this.col = col;
    }

    public String toString() {
        switch (this.type) {
            case STRING: 
            case QSTRING: {
                return "Token [" + this.line + ", " + this.col + "] " + (Object)((Object)this.type) + " |" + this.image + "|";
            }
        }
        return "Token [" + this.line + ", " + this.col + "] " + (Object)((Object)this.type);
    }
}

