/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.csv;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.atlas.csv.CSVToken;
import org.apache.jena.atlas.csv.CSVTokenType;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.iterator.IteratorSlotted;

public class CSVTokenIterator
extends IteratorSlotted<CSVToken> {
    private PeekReader in;
    StringBuilder builder = new StringBuilder();

    public CSVTokenIterator(InputStream input) {
        this.in = PeekReader.makeUTF8(input);
    }

    public CSVTokenIterator(Reader reader) {
        this.in = PeekReader.make(reader);
    }

    @Override
    protected CSVToken moveToNext() {
        int ch = this.in.peekChar();
        if (ch == 13) {
            this.in.readChar();
            ch = this.in.peekChar();
            if (ch != 10) {
                return new CSVToken(this.in.getLineNum(), this.in.getColNum(), CSVTokenType.NL, "\r");
            }
        }
        if (ch == 10) {
            this.in.readChar();
            return new CSVToken(this.in.getLineNum(), this.in.getColNum(), CSVTokenType.NL, "\n");
        }
        if (ch == 44) {
            this.in.readChar();
            return new CSVToken(this.in.getLineNum(), this.in.getColNum(), CSVTokenType.COMMA, ",");
        }
        long line = this.in.getLineNum();
        long col = this.in.getColNum();
        if (ch == 34 || ch == 39) {
            return new CSVToken(line, col, CSVTokenType.QSTRING, this.readQuotedString());
        }
        return new CSVToken(line, col, CSVTokenType.STRING, this.readUnquotedString());
    }

    private String readQuotedString() {
        int qCh;
        this.builder.setLength(0);
        int ch = qCh = this.in.readChar();
        while (true) {
            if ((ch = this.in.readChar()) == -1) {
                CSVParser.exception("Unterminated quoted string at end-of-file", this.in.getLineNum(), this.in.getColNum());
            }
            if (ch == qCh) {
                int ch2 = this.in.peekChar();
                if (ch2 != qCh) break;
                this.in.readChar();
            }
            this.builder.append((char)ch);
        }
        return this.builder.toString();
    }

    private String readUnquotedString() {
        int ch;
        this.builder.setLength(0);
        while ((ch = this.in.peekChar()) != -1 && ch != 13 && ch != 10 && ch != 44) {
            this.in.readChar();
            this.builder.append((char)ch);
        }
        return this.builder.toString();
    }

    @Override
    protected boolean hasMore() {
        return !this.in.eof() && this.in.peekChar() != -1;
    }
}

