/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;

public class LangCSV
implements LangRIOT {
    public static final String CSV_PREFIX = "http://w3c/future-csv-vocab/";
    public static final String CSV_ROW = "http://w3c/future-csv-vocab/row";
    private InputStream input = null;
    private Reader reader = null;
    private String xmlBase;
    private String filename;
    private StreamRDF sink;
    private ParserProfile profile;

    @Override
    public Lang getLang() {
        return RDFLanguages.CSV;
    }

    @Override
    public ParserProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public LangCSV(Reader reader, String xmlBase, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        this.reader = reader;
        this.xmlBase = xmlBase;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), xmlBase, errorHandler);
    }

    public LangCSV(InputStream in, String xmlBase, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        this.input = in;
        this.xmlBase = xmlBase;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), xmlBase, errorHandler);
    }

    @Override
    public void parse() {
        this.sink.start();
        CSVParser parser = this.input != null ? CSVParser.create(this.input) : CSVParser.create(this.reader);
        List<String> row = null;
        ArrayList<Node> predicates = new ArrayList<Node>();
        int rowNum = 0;
        while ((row = parser.parse1()) != null) {
            if (++rowNum == 1) {
                for (String column : row) {
                    Node predicate = this.profile.createURI(this.filename + "#" + column.trim(), rowNum, 0L);
                    predicates.add(predicate);
                }
                continue;
            }
            Node subject = this.profile.createBlankNode(null, -1L, -1L);
            Node predicateRow = this.profile.createURI(CSV_ROW, -1L, -1L);
            Node objectRow = this.profile.createTypedLiteral((rowNum + "").trim(), (RDFDatatype)XSDDatatype.XSDinteger, rowNum, 0L);
            this.sink.triple(this.profile.createTriple(subject, predicateRow, objectRow, rowNum, 0L));
            for (int col = 0; col < row.size(); ++col) {
                Node o;
                Node predicate = (Node)predicates.get(col);
                String columnValue = row.get(col).trim();
                try {
                    double d = Double.parseDouble(columnValue);
                    o = NodeFactory.createLiteral((String)columnValue, (RDFDatatype)XSDDatatype.XSDdouble);
                }
                catch (Exception e2) {
                    o = NodeFactory.createLiteral((String)columnValue);
                }
                this.sink.triple(this.profile.createTriple(subject, predicate, o, rowNum, col));
            }
        }
        this.sink.finish();
    }
}

