/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.iterator.IteratorResourceClosing;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangRDFJSON;
import org.apache.jena.riot.lang.LangRDFXML;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.LangTriG;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.lang.PipedQuadsStream;
import org.apache.jena.riot.lang.PipedRDFIterator;
import org.apache.jena.riot.lang.PipedTriplesStream;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRILib;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;

@Deprecated
public class RiotReader {
    public static void parseTriples(String filename, Sink<Triple> sink) {
        RiotReader.parseTriples(filename, null, null, sink);
    }

    public static void parseTriples(String filename, Lang lang, String baseIRI, Sink<Triple> sink) {
        StreamRDF dest = StreamRDFLib.sinkTriples(sink);
        RiotReader.parseTriples(filename, lang, baseIRI, dest);
    }

    public static void parseTriples(InputStream in, Lang lang, String baseIRI, Sink<Triple> sink) {
        StreamRDF dest = StreamRDFLib.sinkTriples(sink);
        RiotReader.parseTriples(in, lang, baseIRI, dest);
    }

    public static void parseQuads(String filename, Sink<Quad> sink) {
        RiotReader.parseQuads(filename, null, null, sink);
    }

    public static void parseQuads(String filename, Lang lang, String baseIRI, Sink<Quad> sink) {
        StreamRDF dest = StreamRDFLib.sinkQuads(sink);
        RiotReader.parseQuads(filename, lang, baseIRI, dest);
    }

    public static void parseQuads(InputStream in, Lang lang, String baseIRI, Sink<Quad> sink) {
        StreamRDF dest = StreamRDFLib.sinkQuads(sink);
        RiotReader.parseQuads(in, lang, baseIRI, dest);
    }

    public static void parseTriples(String filename, StreamRDF dest) {
        RiotReader.parseTriples(filename, null, null, dest);
    }

    public static void parseTriples(String filename, Lang lang, String baseIRI, StreamRDF dest) {
        org.apache.jena.riot.RiotReader.parse(filename, lang, baseIRI, dest);
    }

    public static void parseTriples(InputStream in, Lang lang, String baseIRI, StreamRDF dest) {
        org.apache.jena.riot.RiotReader.parse(in, lang, baseIRI, dest);
    }

    public static void parseQuads(String filename, StreamRDF dest) {
        RiotReader.parseQuads(filename, null, null, dest);
    }

    public static void parseQuads(String filename, Lang lang, String baseIRI, StreamRDF dest) {
        org.apache.jena.riot.RiotReader.parse(filename, lang, baseIRI, dest);
    }

    public static void parseQuads(InputStream in, Lang lang, String baseIRI, StreamRDF dest) {
        org.apache.jena.riot.RiotReader.parse(in, lang, baseIRI, dest);
    }

    public static LangRIOT createParserTriples(InputStream input, Lang lang, String baseIRI, StreamRDF dest) {
        return org.apache.jena.riot.RiotReader.createParser(input, lang, baseIRI, dest);
    }

    public static LangRIOT createParserTriples(Tokenizer tokenizer, Lang lang, String baseIRI, StreamRDF dest) {
        return org.apache.jena.riot.RiotReader.createParser(tokenizer, lang, baseIRI, dest);
    }

    public static Iterator<Triple> createIteratorTriples(final InputStream input, final Lang lang, final String baseIRI) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return new IteratorResourceClosing<Triple>(RiotReader.createParserNTriples(input, null), input);
        }
        PipedRDFIterator<Triple> it = new PipedRDFIterator<Triple>();
        final PipedTriplesStream out = new PipedTriplesStream(it);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                RiotReader.parseTriples(input, lang, baseIRI, (StreamRDF)out);
            }
        });
        t.start();
        return it;
    }

    public static LangRIOT createParserQuads(InputStream input, Lang lang, String baseIRI, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserQuads(tokenizer, lang, baseIRI, dest);
    }

    public static LangRIOT createParserQuads(Tokenizer tokenizer, Lang lang, String baseIRI, StreamRDF dest) {
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotReader.createParserNQuads(tokenizer, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.TRIG, lang)) {
            return RiotReader.createParserTriG(tokenizer, baseIRI, dest);
        }
        dest = StreamRDFLib.extendTriplesToQuads(dest);
        return RiotReader.createParserTriples(tokenizer, lang, baseIRI, dest);
    }

    public static Iterator<Quad> createIteratorQuads(final InputStream input, final Lang lang, final String baseIRI) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return new IteratorResourceClosing<Quad>(RiotReader.createParserNQuads(input, null), input);
        }
        PipedRDFIterator<Quad> it = new PipedRDFIterator<Quad>();
        final PipedQuadsStream out = new PipedQuadsStream(it);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                RiotReader.parseQuads(input, lang, baseIRI, (StreamRDF)out);
            }
        });
        t.start();
        return it;
    }

    public static LangTurtle createParserTurtle(InputStream input, String baseIRI, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserTurtle(tokenizer, baseIRI, dest);
    }

    public static LangTurtle createParserTurtle(Tokenizer tokenizer, String baseIRI, StreamRDF dest) {
        LangTurtle parser = new LangTurtle(tokenizer, RiotLib.profile(RDFLanguages.TURTLE, baseIRI), dest);
        return parser;
    }

    public static LangRDFXML createParserRDFXML(InputStream input, String baseIRI, StreamRDF dest) {
        if (baseIRI == null) {
            baseIRI = RiotReader.chooseBaseIRI();
        }
        LangRDFXML parser = LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        return parser;
    }

    public static LangRDFJSON createParserRdfJson(Tokenizer tokenizer, StreamRDF dest) {
        LangRDFJSON parser = new LangRDFJSON(tokenizer, RiotLib.profile(RDFLanguages.RDFJSON, null), dest);
        return parser;
    }

    public static LangRDFJSON createParserRdfJson(InputStream input, StreamRDF dest) {
        TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.makeUTF8(input));
        return RiotReader.createParserRdfJson(tokenizer, dest);
    }

    public static LangTriG createParserTriG(InputStream input, String baseIRI, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserTriG(tokenizer, baseIRI, dest);
    }

    public static LangTriG createParserTriG(Tokenizer tokenizer, String baseIRI, StreamRDF dest) {
        if (baseIRI == null) {
            baseIRI = RiotReader.chooseBaseIRI();
        }
        LangTriG parser = new LangTriG(tokenizer, RiotLib.profile(RDFLanguages.TRIG, baseIRI), dest);
        return parser;
    }

    public static LangNTriples createParserNTriples(InputStream input, StreamRDF dest) {
        return RiotReader.createParserNTriples(input, CharSpace.UTF8, dest);
    }

    public static LangNTriples createParserNTriples(InputStream input, CharSpace charSpace, StreamRDF dest) {
        Tokenizer tokenizer = charSpace == CharSpace.ASCII ? TokenizerFactory.makeTokenizerASCII(input) : TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserNTriples(tokenizer, dest);
    }

    public static LangNTriples createParserNTriples(Tokenizer tokenizer, StreamRDF dest) {
        LangNTriples parser = new LangNTriples(tokenizer, RiotLib.profile(RDFLanguages.NTRIPLES, null), dest);
        return parser;
    }

    public static LangNQuads createParserNQuads(InputStream input, StreamRDF dest) {
        return RiotReader.createParserNQuads(input, CharSpace.UTF8, dest);
    }

    public static LangNQuads createParserNQuads(InputStream input, CharSpace charSpace, StreamRDF dest) {
        Tokenizer tokenizer = charSpace == CharSpace.ASCII ? TokenizerFactory.makeTokenizerASCII(input) : TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserNQuads(tokenizer, dest);
    }

    public static LangNQuads createParserNQuads(Tokenizer tokenizer, StreamRDF dest) {
        LangNQuads parser = new LangNQuads(tokenizer, RiotLib.profile(RDFLanguages.NQUADS, null), dest);
        return parser;
    }

    public static String chooseBaseIRI() {
        return IRIResolver.chooseBaseURI().toString();
    }

    public static String chooseBaseIRI(String baseIRI, String filename) {
        if (baseIRI != null) {
            return baseIRI;
        }
        if (filename == null || filename.equals("-")) {
            return "http://localhost/stdin/";
        }
        String x = IRILib.filenameToIRI(filename);
        return x;
    }

    private static String nameForFile(String filename) {
        if (filename == null || filename.equals("-")) {
            return "stdin";
        }
        return filename;
    }
}

