/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.util.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;

public class Version {
    private List<Class<?>> classes = new ArrayList();
    private static String FIELD_VERSION = "VERSION";
    private static String FIELD_BUILD_DATE = "BUILD_DATE";
    private static String[] fields = new String[]{FIELD_VERSION, FIELD_BUILD_DATE};

    public void addClass(Class<?> c) {
        if (!this.classes.contains(c)) {
            this.classes.add(c);
        }
    }

    public void print() {
        this.print(IndentedWriter.stdout);
    }

    public void print(IndentedWriter writer) {
        for (Class<?> c : this.classes) {
            String x = Utils.classShortName(c);
            Version.fields(writer, x, c);
        }
    }

    public String toString(boolean singleLine) {
        IndentedLineBuffer buffer = new IndentedLineBuffer(false);
        Iterator<Class<?>> iter = this.classes.iterator();
        while (iter.hasNext()) {
            Class<?> c = iter.next();
            String component = Utils.classShortName(c);
            String version2 = Version.field(FIELD_VERSION, c);
            String timestamp = Version.field(FIELD_BUILD_DATE, c);
            buffer.append("%s Version %s (Built %s)", component, version2, timestamp);
            if (!iter.hasNext()) continue;
            if (!singleLine) {
                buffer.println();
                continue;
            }
            buffer.print(", ");
        }
        return buffer.asString();
    }

    public String toString() {
        return this.toString(false);
    }

    private static void fields(IndentedWriter writer, String prefix, Class<?> cls) {
        for (String field : fields) {
            Version.printField(writer, prefix, field, cls);
        }
    }

    private static String field(String fieldName, Class<?> cls) {
        try {
            Field f = cls.getDeclaredField(fieldName);
            return f.get(null).toString();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        return "<error>";
    }

    private static void printField(IndentedWriter out, String prefix, String fieldName, Class<?> cls) {
        out.print(prefix);
        out.print(": ");
        out.pad(12);
        out.print(fieldName);
        out.print(": ");
        out.print(Version.field(fieldName, cls));
        out.println();
        out.flush();
    }
}

