/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.csv;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.csv.CSVParseException;
import org.apache.jena.atlas.csv.CSVToken;
import org.apache.jena.atlas.csv.CSVTokenIterator;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.iterator.PeekIterator;

public class CSVParser
implements Iterable<List<String>> {
    private final CSVTokenIterator iter;
    private final PeekIterator<CSVToken> pIter;

    public static CSVParser create(String filename) {
        InputStream input = IO.openFile(filename);
        return CSVParser.create(input);
    }

    public static CSVParser create(InputStream input) {
        CSVTokenIterator iter = new CSVTokenIterator(input);
        CSVParser parser = new CSVParser(iter);
        return parser;
    }

    public static CSVParser create(Reader input) {
        CSVTokenIterator iter = new CSVTokenIterator(input);
        CSVParser parser = new CSVParser(iter);
        return parser;
    }

    public CSVParser(CSVTokenIterator iter) {
        this.iter = iter;
        this.pIter = new PeekIterator<CSVToken>(iter);
    }

    @Override
    public Iterator<List<String>> iterator() {
        return new IteratorSlotted<List<String>>(){

            @Override
            protected List<String> moveToNext() {
                return CSVParser.this.parse1();
            }

            @Override
            protected boolean hasMore() {
                return true;
            }
        };
    }

    public List<String> parse1() {
        ArrayList<String> line = new ArrayList<String>(100);
        block10: while (this.pIter.hasNext()) {
            CSVToken t = this.pIter.next();
            switch (t.type) {
                case EOF: {
                    return null;
                }
                case NL: {
                    line.add("");
                    return line;
                }
                case STRING: 
                case QSTRING: {
                    line.add(t.image);
                    break;
                }
                case COMMA: {
                    line.add("");
                    continue block10;
                }
                default: {
                    CSVParser.exception("Syntax error: expected a string or comma.", t);
                }
            }
            if (!this.pIter.hasNext()) {
                return line;
            }
            CSVToken t2 = this.pIter.peek();
            switch (t2.type) {
                case COMMA: {
                    this.pIter.next();
                    continue block10;
                }
                case EOF: 
                case NL: {
                    this.pIter.next();
                    return line;
                }
            }
            CSVParser.exception("Syntax error: expect comma or end of line.", t);
        }
        return null;
    }

    static void exception(String msg, CSVToken t) {
        if (t != null && t.line >= 0L && t.col > 0L) {
            msg = String.format("[%s, %s] %s", t.line, t.col, msg);
        }
        throw new CSVParseException(msg);
    }

    static void exception(String msg, long line, long col) {
        if (line >= 0L && col > 0L) {
            msg = String.format("[%s, %s] %s", line, col, msg);
        }
        throw new CSVParseException(msg);
    }
}

