/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.out.JsonLDWriter;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.NQuadsWriter;
import org.apache.jena.riot.writer.NTriplesWriter;
import org.apache.jena.riot.writer.NullWriter;
import org.apache.jena.riot.writer.RDFJSONWriter;
import org.apache.jena.riot.writer.RDFXMLAbbrevWriter;
import org.apache.jena.riot.writer.RDFXMLPlainWriter;
import org.apache.jena.riot.writer.TriGWriter;
import org.apache.jena.riot.writer.TriGWriterBlocks;
import org.apache.jena.riot.writer.TriGWriterFlat;
import org.apache.jena.riot.writer.TurtleWriter;
import org.apache.jena.riot.writer.TurtleWriterBlocks;
import org.apache.jena.riot.writer.TurtleWriterFlat;

public class RDFWriterRegistry {
    private static Map<RDFFormat, WriterGraphRIOTFactory> registryGraph;
    private static Map<RDFFormat, WriterDatasetRIOTFactory> registryDataset;
    private static Map<Lang, RDFFormat> langToFormat;
    static WriterGraphRIOTFactory wgfactory;
    static WriterDatasetRIOTFactory wdsfactory;
    static WriterDatasetRIOTFactory wdsJsonldfactory;
    static WriterGraphRIOTFactory wgJsonldfactory;

    public static void init() {
    }

    private static void init$() {
        RDFWriterRegistry.register(Lang.TURTLE, RDFFormat.TURTLE);
        RDFWriterRegistry.register(Lang.N3, RDFFormat.TURTLE);
        RDFWriterRegistry.register(Lang.NTRIPLES, RDFFormat.NTRIPLES);
        RDFWriterRegistry.register(Lang.RDFXML, RDFFormat.RDFXML);
        RDFWriterRegistry.register(Lang.JSONLD, RDFFormat.JSONLD);
        RDFWriterRegistry.register(Lang.RDFJSON, RDFFormat.RDFJSON);
        RDFWriterRegistry.register(Lang.TRIG, RDFFormat.TRIG);
        RDFWriterRegistry.register(Lang.NQUADS, RDFFormat.NQUADS);
        RDFWriterRegistry.register(Lang.RDFNULL, RDFFormat.RDFNULL);
        RDFWriterRegistry.register(RDFFormat.TURTLE_PRETTY, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TURTLE_BLOCKS, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TURTLE_FLAT, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NTRIPLES, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NTRIPLES_ASCII, wgfactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD, wgJsonldfactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD_FLAT, wgJsonldfactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD_PRETTY, wgJsonldfactory);
        RDFWriterRegistry.register(RDFFormat.RDFJSON, wgfactory);
        RDFWriterRegistry.register(RDFFormat.RDFXML_PRETTY, wgfactory);
        RDFWriterRegistry.register(RDFFormat.RDFXML_PLAIN, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_PRETTY, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_BLOCKS, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_FLAT, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS_ASCII, wgfactory);
        RDFWriterRegistry.register(RDFFormat.RDFNULL, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_PRETTY, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_BLOCKS, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_FLAT, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS_ASCII, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.RDFNULL, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD, wdsJsonldfactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD_FLAT, wdsJsonldfactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD_PRETTY, wdsJsonldfactory);
    }

    public static void register(RDFFormat serialization, WriterGraphRIOTFactory graphWriterFactory) {
        registryGraph.put(serialization, graphWriterFactory);
    }

    public static void register(RDFFormat serialization, WriterDatasetRIOTFactory datasetWriterFactory) {
        registryDataset.put(serialization, datasetWriterFactory);
    }

    private static void register(RDFFormat serialization) {
    }

    public static void register(Lang lang, RDFFormat format) {
        RDFWriterRegistry.register(format);
        langToFormat.put(lang, format);
    }

    public static RDFFormat defaultSerialization(Lang lang) {
        return langToFormat.get(lang);
    }

    public static boolean contains(Lang lang) {
        if (!langToFormat.containsKey(lang)) {
            return false;
        }
        RDFFormat fmt = langToFormat.get(lang);
        return RDFWriterRegistry.contains(fmt);
    }

    public static boolean contains(RDFFormat format) {
        return langToFormat.containsKey(format.getLang()) && (registryGraph.containsKey(format) || registryDataset.containsKey(format));
    }

    public static Collection<RDFFormat> registeredGraphFormats() {
        return Collections.unmodifiableSet(registryGraph.keySet());
    }

    public static Collection<RDFFormat> registeredDatasetFormats() {
        return Collections.unmodifiableSet(registryDataset.keySet());
    }

    public static WriterGraphRIOTFactory getWriterGraphFactory(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        if (serialization == null) {
            throw new RiotException("No default serialization for language " + lang);
        }
        return RDFWriterRegistry.getWriterGraphFactory(serialization);
    }

    public static WriterGraphRIOTFactory getWriterGraphFactory(RDFFormat serialization) {
        return registryGraph.get(serialization);
    }

    public static WriterDatasetRIOTFactory getWriterDatasetFactory(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        if (serialization == null) {
            throw new RiotException("No default serialization for language " + lang);
        }
        return RDFWriterRegistry.getWriterDatasetFactory(serialization);
    }

    public static WriterDatasetRIOTFactory getWriterDatasetFactory(RDFFormat serialization) {
        if (serialization == null) {
            return null;
        }
        return registryDataset.get(serialization);
    }

    static {
        RIOT.init();
        registryGraph = new HashMap<RDFFormat, WriterGraphRIOTFactory>();
        registryDataset = new HashMap<RDFFormat, WriterDatasetRIOTFactory>();
        langToFormat = new HashMap<Lang, RDFFormat>();
        wgfactory = new WriterGraphRIOTFactory(){

            @Override
            public WriterGraphRIOT create(RDFFormat serialization) {
                if (Lib.equal(RDFFormat.TURTLE_PRETTY, serialization)) {
                    return new TurtleWriter();
                }
                if (Lib.equal(RDFFormat.TURTLE_BLOCKS, serialization)) {
                    return new TurtleWriterBlocks();
                }
                if (Lib.equal(RDFFormat.TURTLE_FLAT, serialization)) {
                    return new TurtleWriterFlat();
                }
                if (Lib.equal(RDFFormat.NTRIPLES_UTF8, serialization)) {
                    return new NTriplesWriter();
                }
                if (Lib.equal(RDFFormat.NTRIPLES_ASCII, serialization)) {
                    return new NTriplesWriter(CharSpace.ASCII);
                }
                if (Lib.equal(RDFFormat.RDFJSON, serialization)) {
                    return new RDFJSONWriter();
                }
                if (Lib.equal(RDFFormat.RDFXML_PRETTY, serialization)) {
                    return new RDFXMLAbbrevWriter();
                }
                if (Lib.equal(RDFFormat.RDFXML_PLAIN, serialization)) {
                    return new RDFXMLPlainWriter();
                }
                WriterDatasetRIOT dsw = wdsfactory.create(serialization);
                if (dsw != null) {
                    return RiotLib.adapter(dsw);
                }
                return null;
            }
        };
        wdsfactory = new WriterDatasetRIOTFactory(){

            @Override
            public WriterDatasetRIOT create(RDFFormat serialization) {
                if (Lib.equal(RDFFormat.TRIG_PRETTY, serialization)) {
                    return new TriGWriter();
                }
                if (Lib.equal(RDFFormat.TRIG_BLOCKS, serialization)) {
                    return new TriGWriterBlocks();
                }
                if (Lib.equal(RDFFormat.TRIG_FLAT, serialization)) {
                    return new TriGWriterFlat();
                }
                if (Lib.equal(RDFFormat.NQUADS_UTF8, serialization)) {
                    return new NQuadsWriter();
                }
                if (Lib.equal(RDFFormat.NQUADS_ASCII, serialization)) {
                    return new NQuadsWriter(CharSpace.ASCII);
                }
                if (Lib.equal(RDFFormat.RDFNULL, serialization)) {
                    return NullWriter.factory.create(RDFFormat.RDFNULL);
                }
                return null;
            }
        };
        wdsJsonldfactory = new WriterDatasetRIOTFactory(){

            @Override
            public WriterDatasetRIOT create(RDFFormat syntaxForm) {
                return new JsonLDWriter(syntaxForm);
            }
        };
        wgJsonldfactory = new WriterGraphRIOTFactory(){

            @Override
            public WriterGraphRIOT create(RDFFormat syntaxForm) {
                return RiotLib.adapter(new JsonLDWriter(syntaxForm));
            }
        };
        RDFWriterRegistry.init$();
    }
}

