/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.IRILib;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;

public class LangCSV
implements LangRIOT {
    public static final String CSV_PREFIX = "http://w3c/future-csv-vocab/";
    public static final String CSV_ROW = "http://w3c/future-csv-vocab/row";
    private InputStream input = null;
    private Reader reader = null;
    private String base;
    private String filename;
    private StreamRDF sink;
    private ParserProfile profile;

    @Override
    public Lang getLang() {
        return RDFLanguages.CSV;
    }

    @Override
    public ParserProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public LangCSV(Reader reader, String base, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        this.reader = reader;
        this.base = base;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), base, errorHandler);
    }

    public LangCSV(InputStream in, String base, String filename, ErrorHandler errorHandler, StreamRDF sink) {
        this.input = in;
        this.base = base;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), base, errorHandler);
    }

    @Override
    public void parse() {
        this.sink.start();
        CSVParser parser = this.input != null ? CSVParser.create(this.input) : CSVParser.create(this.reader);
        List<String> row = null;
        ArrayList<Node> predicates = new ArrayList<Node>();
        int rowNum = 0;
        while ((row = parser.parse1()) != null) {
            if (rowNum == 0) {
                for (String column : row) {
                    String uri = IRIResolver.resolveString(this.filename) + "#" + LangCSV.toSafeLocalname(column);
                    Node predicate = this.profile.createURI(uri, rowNum, 0L);
                    predicates.add(predicate);
                }
            } else {
                Node subject = LangCSV.caculateSubject(rowNum, this.filename);
                Node predicateRow = this.profile.createURI(CSV_ROW, -1L, -1L);
                Node objectRow = this.profile.createTypedLiteral(rowNum + "", (RDFDatatype)XSDDatatype.XSDinteger, rowNum, 0L);
                this.sink.triple(this.profile.createTriple(subject, predicateRow, objectRow, rowNum, 0L));
                for (int col = 0; col < row.size(); ++col) {
                    Node o;
                    Node predicate = (Node)predicates.get(col);
                    String columnValue = row.get(col).trim();
                    try {
                        double d = Double.parseDouble(columnValue);
                        o = NodeFactory.createLiteral((String)columnValue, (RDFDatatype)XSDDatatype.XSDdouble);
                    }
                    catch (Exception e2) {
                        o = NodeFactory.createLiteral((String)columnValue);
                    }
                    this.sink.triple(this.profile.createTriple(subject, predicate, o, rowNum, col));
                }
            }
            ++rowNum;
        }
        this.sink.finish();
    }

    public static String toSafeLocalname(String raw) {
        String ret = raw.trim();
        return LangCSV.encodeURIComponent(ret);
    }

    public static String encodeURIComponent(String s) {
        return IRILib.encodeUriComponent(s);
    }

    public static Node caculateSubject(int rowNum, String filename) {
        Node subject = NodeFactory.createAnon();
        return subject;
    }
}

