/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.system.StreamRDF;

public class WriterStreamRDFTuples
implements StreamRDF {
    protected final AWriter out;
    protected final NodeFormatter nodeFmt;

    public WriterStreamRDFTuples(AWriter w) {
        this(w, CharSpace.UTF8);
    }

    public WriterStreamRDFTuples(AWriter w, CharSpace charSpace) {
        this.out = w;
        this.nodeFmt = new NodeFormatterNT(charSpace);
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
        IO.flush(this.out);
    }

    @Override
    public void triple(Triple triple) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        this.format(s);
        this.out.print(" ");
        this.format(p);
        this.out.print(" ");
        this.format(o);
        this.out.print(" .\n");
    }

    @Override
    public void quad(Quad quad) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        this.format(s);
        this.out.print(" ");
        this.format(p);
        this.out.print(" ");
        this.format(o);
        if (WriterStreamRDFTuples.outputGraphSlot(g)) {
            this.out.print(" ");
            this.format(g);
        }
        this.out.print(" .\n");
    }

    private void format(Node n) {
        this.nodeFmt.format(this.out, n);
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri2) {
    }

    private static boolean outputGraphSlot(Node g) {
        return g != null && g != Quad.tripleInQuad && !Quad.isDefaultGraph(g);
    }
}

