/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.BIOInput;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.CSVInput;
import com.hp.hpl.jena.sparql.resultset.JSONInput;
import com.hp.hpl.jena.sparql.resultset.RDFInput;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.resultset.ResultSetPeekable;
import com.hp.hpl.jena.sparql.resultset.ResultSetPeeking;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.resultset.TSVInput;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderTable;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ResultSetMgr;

public class ResultSetFactory {
    public static ResultSet load(String filenameOrURI) {
        return ResultSetFactory.load(filenameOrURI, null);
    }

    public static ResultSet load(String filenameOrURI, ResultsFormat format) {
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        InputStream in = IO.openFile(filenameOrURI);
        return ResultSetFactory.load(in, format);
    }

    public static ResultSet load(InputStream input, ResultsFormat format) {
        Lang lang;
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if ((lang = ResultsFormat.convert(format)) != null) {
            return ResultSetMgr.read(input, lang);
        }
        if (format.equals(ResultsFormat.FMT_RS_JSON)) {
            return JSONInput.fromJSON(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_TSV)) {
            return TSVInput.fromTSV(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_CSV)) {
            return CSVInput.fromCSV(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_BIO)) {
            return BIOInput.fromBIO(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_XML)) {
            return ResultSetFactory.fromXML(input);
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.warn(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RDF_XML)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null);
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultsFormat.FMT_RDF_TTL)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "TURTLE");
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultsFormat.FMT_RDF_N3)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "N3");
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultsFormat.FMT_RDF_NT)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "N-TRIPLES");
            return ResultSetFactory.fromRDF(m);
        }
        Log.warn(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static Model loadAsModel(String filenameOrURI) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, null);
    }

    public static Model loadAsModel(Model model, String filenameOrURI) {
        return ResultSetFactory.loadAsModel(model, filenameOrURI, null);
    }

    public static Model loadAsModel(String filenameOrURI, ResultsFormat format) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, format);
    }

    public static Model loadAsModel(Model model, String filenameOrURI, ResultsFormat format) {
        if (model == null) {
            model = GraphFactory.makeDefaultModel();
        }
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.fatal(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RS_XML) || format.equals(ResultsFormat.FMT_RS_JSON)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
                if (in == null) {
                    throw new NotFoundException(filenameOrURI);
                }
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File not found: " + filenameOrURI);
            }
            SPARQLResult x = null;
            x = format.equals(ResultsFormat.FMT_RS_JSON) ? JSONInput.make(in, GraphFactory.makeDefaultModel()) : XMLInput.make(in, GraphFactory.makeDefaultModel());
            if (x.isResultSet()) {
                ResultSetFormatter.asRDF(model, x.getResultSet());
            } else {
                ResultSetFormatter.asRDF(model, x.getBooleanResult());
            }
            return model;
        }
        if (ResultsFormat.isRDFGraphSyntax(format)) {
            return FileManager.get().readModel(model, filenameOrURI);
        }
        Log.fatal(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static SPARQLResult result(String filenameOrURI) {
        return ResultSetFactory.result(filenameOrURI, null);
    }

    public static SPARQLResult result(String filenameOrURI, ResultsFormat format) {
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.fatal(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RS_XML) || format.equals(ResultsFormat.FMT_RS_JSON) || format.equals(ResultsFormat.FMT_RS_TSV) || format.equals(ResultsFormat.FMT_RS_CSV)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
                if (in == null) {
                    throw new NotFoundException(filenameOrURI);
                }
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File not found: " + filenameOrURI);
            }
            Object x = null;
            if (format.equals(ResultsFormat.FMT_RS_JSON)) {
                return JSONInput.make(in, GraphFactory.makeDefaultModel());
            }
            if (format.equals(ResultsFormat.FMT_RS_XML)) {
                return XMLInput.make(in, GraphFactory.makeDefaultModel());
            }
            if (format.equals(ResultsFormat.FMT_RS_TSV)) {
                ResultSet rs = TSVInput.fromTSV(in);
                return new SPARQLResult(rs);
            }
            if (format.equals(ResultsFormat.FMT_RS_CSV)) {
                ResultSet rs = CSVInput.fromCSV(in);
                return new SPARQLResult(rs);
            }
            if (format.equals(ResultsFormat.FMT_RS_BIO)) {
                ResultSet rs = BIOInput.fromBIO(in);
                return new SPARQLResult(rs);
            }
        }
        if (ResultsFormat.isRDFGraphSyntax(format)) {
            Model model = FileManager.get().loadModel(filenameOrURI);
            return new SPARQLResult(model);
        }
        Log.fatal(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static ResultSet fromXML(InputStream in) {
        return XMLInput.fromXML(in);
    }

    public static ResultSet fromXML(String str2) {
        return XMLInput.fromXML(str2);
    }

    public static ResultSet fromRDF(Model model) {
        return new RDFInput(model);
    }

    public static ResultSet fromJSON(InputStream in) {
        return JSONInput.fromJSON(in);
    }

    public static ResultSet fromTSV(InputStream in) {
        return TSVInput.fromTSV(in);
    }

    public static ResultSet fromSSE(InputStream in) {
        Item item = SSE.parse(in);
        Log.warn(ResultSet.class, "Reading SSE result set not full implemented");
        BuilderTable.build(item);
        return null;
    }

    public static ResultSet makeResults(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(ResultSet resultSet) {
        if (resultSet instanceof ResultSetRewindable) {
            ResultSetRewindable rsw = (ResultSetRewindable)resultSet;
            rsw.reset();
            return rsw;
        }
        return new ResultSetMem(resultSet);
    }

    public static ResultSetPeekable makePeekable(ResultSet resultSet) {
        return new ResultSetPeeking(resultSet);
    }

    public static ResultSetRewindable copyResults(ResultSet results) {
        return new ResultSetMem(results);
    }

    public static ResultSet create(QueryIterator queryIterator, List<String> vars) {
        return new ResultSetStream(vars, null, queryIterator);
    }
}

