/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.DatasetGraphBaseFind;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Lib;

public abstract class DatasetGraphCollection
extends DatasetGraphBaseFind {
    @Override
    public void add(Quad quad) {
        Graph g = this.fetchGraph(quad.getGraph());
        if (g == null) {
            throw new JenaException("No such graph: " + quad.getGraph());
        }
        g.add(quad.asTriple());
    }

    @Override
    public void delete(Quad quad) {
        Graph g = this.fetchGraph(quad.getGraph());
        if (g == null) {
            throw new JenaException("No such graph: " + quad.getGraph());
        }
        g.delete(quad.asTriple());
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return DatasetGraphCollection.triples2quadsDftGraph((Iterator<Triple>)this.getDefaultGraph().find(s, p, o));
    }

    protected Iter<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        Graph graph = this.fetchGraph(g);
        if (graph == null) {
            return Iter.nullIter();
        }
        return DatasetGraphCollection.triples2quads(g, (Iterator<Triple>)graph.find(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        Iterator<Node> gnames = this.listGraphNodes();
        Iterator iter = null;
        while (gnames.hasNext()) {
            Node gn = gnames.next();
            Iterator qIter = this.findInSpecificNamedGraph(gn, s, p, o);
            if (qIter == null) continue;
            iter = Iter.append(iter, qIter);
        }
        return iter;
    }

    @Override
    public abstract Iterator<Node> listGraphNodes();

    @Override
    public void clear() {
        this.getDefaultGraph().clear();
        Iterator<Node> gnIter = this.listGraphNodes();
        while (gnIter.hasNext()) {
            Node gn = gnIter.next();
            this.removeGraph(gn);
        }
    }

    protected Graph fetchGraph(Node gn) {
        if (Quad.isDefaultGraph(gn) || Lib.equal(gn, Quad.tripleInQuad)) {
            return this.getDefaultGraph();
        }
        return this.getGraph(gn);
    }
}

