/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.sse.builders.BuilderExpr;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import com.hp.hpl.jena.sparql.sse.builders.BuilderOp;
import com.hp.hpl.jena.sparql.sse.builders.BuilderPath;
import com.hp.hpl.jena.sparql.sse.builders.BuilderTable;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandler;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandlerPlain;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandlerResolver;
import com.hp.hpl.jena.sparql.sse.lang.SSE_Parser;
import com.hp.hpl.jena.sparql.sse.writers.WriterGraph;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.sse.writers.WriterOp;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;

public class SSE {
    protected static PrefixMapping defaultDefaultPrefixMapRead = new PrefixMappingImpl();
    public static PrefixMapping defaultPrefixMapRead;
    protected static PrefixMapping defaultDefaultPrefixMapWrite;
    public static PrefixMapping defaultPrefixMapWrite;
    private static boolean useResolver;

    private SSE() {
    }

    public static PrefixMapping getDefaultPrefixMapRead() {
        return defaultPrefixMapRead;
    }

    public static void setDefaultPrefixMapRead(PrefixMapping pmap) {
        defaultPrefixMapRead = pmap;
    }

    public static PrefixMapping getDefaultPrefixMapWrite() {
        return defaultPrefixMapWrite;
    }

    public static void setDefaultPrefixMapWrite(PrefixMapping pmap) {
        defaultPrefixMapWrite = pmap;
    }

    public static Node parseNode(String str2) {
        return SSE.parseNode(str2, null);
    }

    public static Node parseNode(String str2, PrefixMapping pmap) {
        return SSE.parseNode(new StringReader(str2), pmap);
    }

    public static Quad parseQuad(String s) {
        return SSE.parseQuad(s, null);
    }

    public static Quad parseQuad(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + s);
        }
        return BuilderGraph.buildQuad(item.getList());
    }

    public static Triple parseTriple(String str2) {
        return SSE.parseTriple(str2, null);
    }

    public static Triple parseTriple(String str2, PrefixMapping pmap) {
        Item item = SSE.parse(str2, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + str2);
        }
        return BuilderGraph.buildTriple(item.getList());
    }

    public static Path parsePath(String str2) {
        return SSE.parsePath(str2, null);
    }

    public static Path parsePath(String str2, PrefixMapping pmap) {
        Item item = SSE.parse(str2, pmap);
        if (!item.isList()) {
            throw new ARQException("Not a list: " + str2);
        }
        return BuilderPath.buildPath(item);
    }

    public static Expr parseExpr(String s) {
        return SSE.parseExpr(s, null);
    }

    public static Expr parseExpr(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderExpr.buildExpr(item);
    }

    public static Graph parseGraph(String string) {
        return SSE.parseGraph(string, null);
    }

    public static Graph parseGraph(String string, PrefixMapping pmap) {
        Item item = SSE.parse(string, pmap);
        return BuilderGraph.buildGraph(item);
    }

    public static Graph readGraph(String filename) {
        return SSE.readGraph(filename, null);
    }

    public static Graph readGraph(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderGraph.buildGraph(item);
    }

    public static void readGraph(Graph graph, String filename) {
        SSE.readGraph(graph, filename, null);
    }

    public static void readGraph(Graph graph, String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        BuilderGraph.buildGraph(graph, item);
    }

    public static DatasetGraph parseDatasetGraph(String string) {
        return SSE.parseDatasetGraph(string, null);
    }

    public static DatasetGraph parseDatasetGraph(String string, PrefixMapping pmap) {
        Item item = SSE.parse(string, pmap);
        return BuilderGraph.buildDataset(item);
    }

    public static DatasetGraph readDatasetGraph(String filename) {
        return SSE.readDatasetGraph(filename, null);
    }

    public static DatasetGraph readDatasetGraph(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderGraph.buildDataset(item);
    }

    public static void readDatasetGraph(DatasetGraph dsg, String filename) {
        SSE.readDatasetGraph(dsg, filename, null);
    }

    public static void readDatasetGraph(DatasetGraph dsg, String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        BuilderGraph.buildDataset(dsg, item);
    }

    public static Op readOp(String filename) {
        return Algebra.read(filename);
    }

    public static Op parseOp(String s) {
        return Algebra.parse(s);
    }

    public static Op parseOp(String s, PrefixMapping pmap) {
        return Algebra.parse(s, pmap);
    }

    public static BasicPattern readBGP(String filename) {
        Item item = SSE.readFile(filename, null);
        return BuilderOp.buildBGP(item);
    }

    public static BasicPattern parseBGP(String s) {
        return SSE.parseBGP(s, SSE.getDefaultPrefixMapRead());
    }

    public static BasicPattern parseBGP(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderOp.buildBGP(item);
    }

    public static Table readTable(String filename) {
        return SSE.readTable(filename, null);
    }

    public static Table readTable(String filename, PrefixMapping pmap) {
        Item item = SSE.readFile(filename, pmap);
        return BuilderTable.build(item);
    }

    public static Table parseTable(String s) {
        return SSE.parseTable(s, null);
    }

    public static Table parseTable(String s, PrefixMapping pmap) {
        Item item = SSE.parse(s, pmap);
        return BuilderTable.build(item);
    }

    public static Item readFile(String filename) {
        return SSE.readFile(filename, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Item readFile(String filename, PrefixMapping pmap) {
        Item item;
        FileInputStream in;
        block6: {
            in = null;
            in = new FileInputStream(filename);
            long len = in.getChannel().size();
            if (len != 0L) break block6;
            Item item2 = Item.nil;
            IO.close(in);
            return item2;
        }
        try {
            item = SSE.parse(in, pmap);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new NotFoundException("Not found: " + filename);
                catch (IOException ex2) {
                    throw new ARQException("IOExeption: " + filename, ex2);
                }
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
        return item;
    }

    public static Item parseRaw(String str2) {
        return SSE.parse(str2, (PrefixMapping)new PrefixMappingImpl());
    }

    public static Item parse(String str2) {
        return SSE.parse(str2, null);
    }

    public static Item parse(String str2, PrefixMapping pmap) {
        return SSE.parse(new StringReader(str2), pmap);
    }

    public static Item parse(InputStream in) {
        return SSE.parse(in, null);
    }

    public static Item parse(InputStream in, PrefixMapping pmap) {
        BufferedReader reader = FileUtils.asBufferedUTF8((InputStream)in);
        return SSE.parse(reader, pmap);
    }

    public static void setUseResolver(boolean flag) {
        useResolver = flag;
    }

    private static ParseHandler createParseHandler(PrefixMapping pmap) {
        if (useResolver) {
            Prologue prologue = new Prologue(pmap);
            return new ParseHandlerResolver(prologue);
        }
        return new ParseHandlerPlain();
    }

    private static Node parseNode(Reader reader, PrefixMapping pmap) {
        Item item = SSE.parseTerm(reader, pmap);
        if (item.isSymbol()) {
            String str2 = item.getSymbol();
            if ("true".equalsIgnoreCase(str2)) {
                return NodeConst.nodeTrue;
            }
            if ("false".equalsIgnoreCase(str2)) {
                return NodeConst.nodeFalse;
            }
            throw new SSEParseException("Not a node: " + item, item.getLine(), item.getColumn());
        }
        if (!item.isNode()) {
            throw new SSEParseException("Not a node: " + item, item.getLine(), item.getColumn());
        }
        return item.getNode();
    }

    private static String parseSymbol(Reader reader, PrefixMapping pmap) {
        Item item = SSE.parseTerm(reader, pmap);
        if (!item.isSymbol()) {
            throw new SSEParseException("Not a symbol: " + item, item.getLine(), item.getColumn());
        }
        return item.getSymbol();
    }

    public static Item parseItem(String str2) {
        return SSE.parse(str2, null);
    }

    public static Item parseItem(String str2, PrefixMapping pmap) {
        return SSE.parse(new StringReader(str2), pmap);
    }

    private static Item parseTerm(Reader reader, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = SSE.getDefaultPrefixMapRead();
        }
        ParseHandler handler = SSE.createParseHandler(pmap);
        SSE_Parser.term(reader, handler);
        return handler.getItem();
    }

    public static Item parse(Reader reader) {
        return SSE.parse(reader, null);
    }

    public static Item parse(Reader reader, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = SSE.getDefaultPrefixMapRead();
        }
        ParseHandler handler = SSE.createParseHandler(pmap);
        SSE_Parser.parse(reader, handler);
        return handler.getItem();
    }

    public static String format(Node node) {
        return FmtUtils.stringForNode(node);
    }

    public static String format(Node node, PrefixMapping pmap) {
        return FmtUtils.stringForNode(node, pmap);
    }

    public static void write(Op op) {
        WriterOp.output(IndentedWriter.stdout, op);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Op op) {
        WriterOp.output(out, op);
    }

    public static void write(IndentedWriter out, Op op) {
        WriterOp.output(out, op);
    }

    public static void write(Graph graph) {
        SSE.write(IndentedWriter.stdout, graph);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Graph graph) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, graph);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Graph graph) {
        WriterGraph.output(out, graph, new SerializationContext(graph.getPrefixMapping()));
        out.ensureStartOfLine();
    }

    public static void write(Model model) {
        SSE.write(IndentedWriter.stdout, model);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Model model) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, model);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Model model) {
        WriterGraph.output(out, model.getGraph(), new SerializationContext((PrefixMapping)model));
    }

    public static void write(DatasetGraph dataset) {
        SSE.write(IndentedWriter.stdout, dataset);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, DatasetGraph dataset) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, dataset);
        iOut.flush();
    }

    public static void write(IndentedWriter out, DatasetGraph dataset) {
        WriterGraph.output(out, dataset, SSE.sCxt(dataset.getDefaultGraph()));
    }

    public static void write(Dataset dataset) {
        SSE.write(dataset.asDatasetGraph());
    }

    public static void write(OutputStream out, Dataset dataset) {
        SSE.write(out, dataset.asDatasetGraph());
    }

    public static void write(IndentedWriter out, Dataset dataset) {
        SSE.write(out, dataset.asDatasetGraph());
    }

    public static void write(BasicPattern pattern) {
        SSE.write(IndentedWriter.stdout, pattern);
        IndentedWriter.stdout.flush();
    }

    public static void write(IndentedWriter out, BasicPattern pattern) {
        SSE.write(IndentedWriter.stdout, pattern, null);
        IndentedWriter.stdout.flush();
    }

    public static void write(IndentedWriter out, BasicPattern pattern, PrefixMapping pMap) {
        WriterGraph.output(out, pattern, SSE.sCxt(pMap));
        out.flush();
    }

    public static void write(Triple triple) {
        SSE.write(IndentedWriter.stdout, triple);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Triple triple) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, triple);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Triple triple) {
        WriterNode.output(out, triple, SSE.sCxt(defaultDefaultPrefixMapWrite));
        out.flush();
    }

    public static void write(Quad quad) {
        SSE.write(IndentedWriter.stdout, quad);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Quad quad) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, quad);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Quad quad) {
        WriterNode.output(out, quad, SSE.sCxt(defaultDefaultPrefixMapWrite));
        out.flush();
    }

    public static void write(Node node) {
        SSE.write(IndentedWriter.stdout, node);
        IndentedWriter.stdout.flush();
    }

    public static void write(OutputStream out, Node node) {
        IndentedWriter iOut = new IndentedWriter(out);
        SSE.write(iOut, node);
        iOut.flush();
    }

    public static void write(IndentedWriter out, Node node) {
        WriterNode.output(IndentedWriter.stdout, node, SSE.sCxt(defaultDefaultPrefixMapWrite));
        IndentedWriter.stdout.flush();
    }

    public static SerializationContext sCxt(Graph graph) {
        if (graph != null) {
            return SSE.sCxt(graph.getPrefixMapping());
        }
        return new SerializationContext();
    }

    public static SerializationContext sCxt(PrefixMapping pmap) {
        if (pmap != null) {
            return new SerializationContext(pmap);
        }
        return new SerializationContext();
    }

    static {
        defaultDefaultPrefixMapRead.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        defaultDefaultPrefixMapRead.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        defaultDefaultPrefixMapRead.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultDefaultPrefixMapRead.setNsPrefix("owl", ARQConstants.owlPrefix);
        defaultDefaultPrefixMapRead.setNsPrefix("fn", "http://www.w3.org/2005/xpath-functions#");
        defaultDefaultPrefixMapRead.setNsPrefix("ex", "http://example.org/");
        defaultDefaultPrefixMapRead.setNsPrefix("ns", "http://example.org/ns#");
        defaultDefaultPrefixMapRead.setNsPrefix("", "http://example/");
        defaultPrefixMapRead = defaultDefaultPrefixMapRead;
        defaultDefaultPrefixMapWrite = new PrefixMappingImpl();
        defaultDefaultPrefixMapWrite.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        defaultDefaultPrefixMapWrite.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        defaultDefaultPrefixMapWrite.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultPrefixMapWrite = defaultDefaultPrefixMapWrite;
        useResolver = true;
    }
}

