/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.jena.atlas.csv.CSVParseException;
import org.apache.jena.atlas.io.IO;

public class CSVParser
implements Iterable<List<String>> {
    private final org.apache.commons.csv.CSVParser parser;

    public static CSVParser create(String filename) {
        InputStream input = IO.openFile(filename);
        return CSVParser.create(input);
    }

    public static CSVParser create(InputStream input) {
        CSVParser parser = new CSVParser(new InputStreamReader(input));
        return parser;
    }

    public static CSVParser create(Reader input) {
        CSVParser parser = new CSVParser(input);
        return parser;
    }

    public CSVParser(Reader input) {
        try {
            this.parser = CSVFormat.EXCEL.withQuote('\'').parse(input);
        }
        catch (IOException e2) {
            throw new CSVParseException("Failed to create the CSV parser: " + e2.getMessage(), e2);
        }
    }

    @Override
    public Iterator<List<String>> iterator() {
        ArrayList list = new ArrayList();
        for (CSVRecord record : this.parser) {
            ArrayList<String> row = new ArrayList<String>();
            for (String columnValue : record) {
                row.add(columnValue);
            }
            list.add(row);
        }
        return list.iterator();
    }

    public List<String> parse1() {
        Iterator<List<String>> iterator = this.iterator();
        if (iterator.hasNext()) {
            List<String> firstRow = iterator.next();
            return firstRow;
        }
        return null;
    }

    static void exception(String msg, long line, long col) {
        if (line >= 0L && col > 0L) {
            msg = String.format("[%s, %s] %s", line, col, msg);
        }
        throw new CSVParseException(msg);
    }
}

