/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModDatasetGeneral;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModRemote;
import arq.cmdline.ModResultsOut;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;

public class rsparql
extends CmdARQ {
    protected ModQueryIn modQuery = new ModQueryIn();
    protected ModRemote modRemote = new ModRemote();
    protected ModDatasetGeneral modDesc = new ModDatasetGeneral();
    protected ModResultsOut modResults = new ModResultsOut();

    public static void main(String ... argv) {
        new rsparql(argv).mainRun();
    }

    public rsparql(String[] argv) {
        super(argv);
        super.addModule(this.modRemote);
        super.addModule(this.modQuery);
        super.addModule(this.modDesc);
        super.addModule(this.modResults);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.modRemote.getServiceURL() == null) {
            throw new CmdException("No SPARQL endpoint specificied");
        }
    }

    @Override
    protected void exec() {
        Query query2 = this.modQuery.getQuery();
        try {
            String serviceURL = this.modRemote.getServiceURL();
            QueryExecution qe = QueryExecutionFactory.sparqlService(serviceURL, query2, this.modDesc.getGraphURLs(), this.modDesc.getNamedGraphURLs());
            if (this.modRemote.usePost()) {
                HttpQuery.urlLimit = 0;
            }
            QueryExecUtils.executeQuery(query2, qe, this.modResults.getResultsFormat());
        }
        catch (QueryExceptionHTTP ex) {
            throw new CmdException("HTTP Exeception", (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            System.out.flush();
            ex.printStackTrace(System.err);
        }
    }

    @Override
    protected String getSummary() {
        return null;
    }
}

