/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.lang.Parser;
import com.hp.hpl.jena.sparql.lang.ParserARQ;
import com.hp.hpl.jena.sparql.lang.ParserFactory;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL10;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL11;
import java.util.HashMap;
import java.util.Map;

public class ParserRegistry {
    Map<Syntax, ParserFactory> factories = new HashMap<Syntax, ParserFactory>();
    static ParserRegistry registry = null;

    public static synchronized ParserRegistry get() {
        if (registry == null) {
            ParserRegistry.init();
        }
        return registry;
    }

    private ParserRegistry() {
    }

    private static synchronized void init() {
        ParserRegistry reg = new ParserRegistry();
        reg.add(Syntax.syntaxSPARQL_10, new ParserFactory(){

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxSPARQL_10.equals(syntax);
            }

            @Override
            public Parser create(Syntax syntax) {
                return new ParserSPARQL10();
            }
        });
        reg.add(Syntax.syntaxSPARQL_11, new ParserFactory(){

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxSPARQL_11.equals(syntax);
            }

            @Override
            public Parser create(Syntax syntax) {
                return new ParserSPARQL11();
            }
        });
        reg.add(Syntax.syntaxARQ, new ParserFactory(){

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxARQ.equals(syntax);
            }

            @Override
            public Parser create(Syntax syntax) {
                return new ParserARQ();
            }
        });
        registry = reg;
    }

    public static ParserFactory findFactory(Syntax syntax) {
        return ParserRegistry.get().getFactory(syntax);
    }

    public static Parser parser(Syntax syntax) {
        return ParserRegistry.get().createParser(syntax);
    }

    public ParserFactory getFactory(Syntax syntax) {
        return this.factories.get(syntax);
    }

    public Parser createParser(Syntax syntax) {
        ParserFactory f = this.getFactory(syntax);
        return f != null ? f.create(syntax) : null;
    }

    public static void addFactory(Syntax syntax, ParserFactory f) {
        ParserRegistry.get().add(syntax, f);
    }

    public void add(Syntax syntax, ParserFactory f) {
        if (!f.accept(syntax)) {
            throw new IllegalArgumentException("The given parser factory does not accept the specified syntax.");
        }
        this.factories.put(syntax, f);
    }

    public static void removeFactory(Syntax syntax) {
        ParserRegistry.get().remove(syntax);
    }

    public void remove(Syntax syntax) {
        this.factories.remove(syntax);
    }

    public static boolean containsParserFactory(Syntax syntax) {
        return ParserRegistry.get().containsFactory(syntax);
    }

    public boolean containsFactory(Syntax syntax) {
        return this.factories.containsKey(syntax);
    }
}

