/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.JSONResultsKW;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjena.atlas.json.JSON;
import org.openjena.atlas.json.JsonArray;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.json.JsonValue;
import org.openjena.riot.lang.LabelToNode;

public class JSONInput
extends SPARQLResult {
    Boolean booleanResult = null;
    List<Binding> rows = null;
    List<Var> vars = null;
    LabelToNode labelMap = LabelToNode.createScopeByDocument();

    public static void main(String ... args) throws Exception {
        String FILE = "../ARQ/testing/ResultSet/output.srj";
        FileInputStream in = new FileInputStream(FILE);
        SPARQLResult r = new JSONInput().process(in, null);
        if (r.isBoolean()) {
            System.out.println("ASK: " + r.getBooleanResult());
        }
        if (r.isResultSet()) {
            ResultSetFormatter.out(r.getResultSet());
        }
    }

    public static ResultSet fromJSON(InputStream input) {
        SPARQLResult r = new JSONInput().process(input, null);
        return r.getResultSet();
    }

    public static boolean booleanFromJSON(InputStream input) {
        SPARQLResult r = new JSONInput().process(input, null);
        return r.getBooleanResult();
    }

    public static SPARQLResult make(InputStream input) {
        return JSONInput.make(input, null);
    }

    public static SPARQLResult make(InputStream input, Model model) {
        return new JSONInput().process(input, model);
    }

    public JSONInput() {
    }

    public JSONInput(InputStream in) {
        this(in, null);
    }

    public JSONInput(InputStream in, Model model) {
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        this.process(in, model);
    }

    private SPARQLResult process(InputStream in, Model model) {
        this.parse(in);
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        if (this.rows != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(this.rows.iterator());
            ResultSetStream rs = new ResultSetStream(Var.varNames(this.vars), model, qIter);
            super.set(rs);
        } else {
            super.set(this.booleanResult);
        }
        return this;
    }

    private void parse(InputStream in) {
        JsonObject obj = JSON.parse(in);
        if (obj.hasKey(JSONResultsKW.kBoolean)) {
            JSONInput.checkContains(obj, JSONResultsKW.kHead, JSONResultsKW.kBoolean);
            this.booleanResult = obj.get(JSONResultsKW.kBoolean).getAsBoolean().value();
            this.rows = null;
            return;
        }
        this.rows = new ArrayList<Binding>(1000);
        JSONInput.checkContains(obj, JSONResultsKW.kHead, JSONResultsKW.kResults);
        if (!obj.hasKey(JSONResultsKW.kHead)) {
            throw new ResultSetException("No 'head' for results");
        }
        if (!obj.hasKey(JSONResultsKW.kResults)) {
            throw new ResultSetException("No 'results' for results");
        }
        if (!obj.get(JSONResultsKW.kHead).isObject()) {
            throw new ResultSetException("Key 'head' must have a JSON object as value: found: " + obj.get(JSONResultsKW.kHead));
        }
        JsonObject head = obj.get(JSONResultsKW.kHead).getAsObject();
        String link = JSONInput.stringOrNull(head, JSONResultsKW.kLink);
        this.vars = this.parseVars(head);
        JsonObject results = obj.get(JSONResultsKW.kResults).getAsObject();
        if (!results.get(JSONResultsKW.kBindings).isArray()) {
            throw new ResultSetException("'bindings' must be an array");
        }
        JsonArray array = results.get(JSONResultsKW.kBindings).getAsArray();
        Iterator<JsonValue> iter = array.iterator();
        while (iter.hasNext()) {
            BindingMap b = BindingFactory.create();
            JsonValue v = iter.next();
            if (!v.isObject()) {
                throw new ResultSetException("Entry in 'bindings' array must be an object {}");
            }
            JsonObject x = v.getAsObject();
            Set<String> varNames = x.keys();
            for (String vn : varNames) {
                JsonValue vt;
                if (!this.vars.contains(vn)) {
                    // empty if block
                }
                if (!(vt = x.get(vn)).isObject()) {
                    throw new ResultSetException("Binding for variable '" + vn + "' is not a JSON object: " + vt);
                }
                Node n = this.parseOneTerm(vt.getAsObject());
                b.add(Var.alloc(vn), n);
            }
            this.rows.add(b);
        }
    }

    private List<Var> parseVars(JsonObject obj) {
        if (!obj.get(JSONResultsKW.kVars).isArray()) {
            throw new ResultSetException("Key 'vars' must be a JSON array");
        }
        JsonArray a = obj.get(JSONResultsKW.kVars).getAsArray();
        Iterator<JsonValue> iter = a.iterator();
        ArrayList<Var> vars = new ArrayList<Var>();
        while (iter.hasNext()) {
            JsonValue v = iter.next();
            if (!v.isString()) {
                throw new ResultSetException("Entries in vars array must be strings");
            }
            Var var = Var.alloc(v.getAsString().value());
            vars.add(var);
        }
        return vars;
    }

    private Node parseOneTerm(JsonObject term) {
        JSONInput.checkContains(term, JSONResultsKW.kType, JSONResultsKW.kValue, JSONResultsKW.kXmlLang, JSONResultsKW.kDatatype);
        String type = JSONInput.stringOrNull(term, JSONResultsKW.kType);
        String v = JSONInput.stringOrNull(term, JSONResultsKW.kValue);
        if (JSONResultsKW.kUri.equals(type)) {
            JSONInput.checkContains(term, JSONResultsKW.kType, JSONResultsKW.kValue);
            String uri = v;
            Node n = Node.createURI((String)v);
            return n;
        }
        if (JSONResultsKW.kLiteral.equals(type) || JSONResultsKW.kTypedLiteral.equals(type)) {
            String lang = JSONInput.stringOrNull(term, JSONResultsKW.kXmlLang);
            String dtStr = JSONInput.stringOrNull(term, JSONResultsKW.kDatatype);
            if (lang != null && dtStr != null) {
                throw new ResultSetException("Both language and datatype defined: " + term);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtStr);
            return Node.createLiteral((String)v, (String)lang, (RDFDatatype)dt);
        }
        if (JSONResultsKW.kBnode.equals(type)) {
            return (Node)this.labelMap.get(null, v);
        }
        throw new ResultSetException("Object key not recognized as valid for an RDF term: " + term);
    }

    private static String stringOrNull(JsonObject obj, String key) {
        JsonValue v = obj.get(key);
        if (v == null) {
            return null;
        }
        if (!v.isString()) {
            throw new ResultSetException("Not a string");
        }
        return v.getAsString().value();
    }

    private static void checkContains(JsonObject term, String ... keys) {
        List<String> x = Arrays.asList(keys);
        for (String k : term.keys()) {
            if (x.contains(k)) continue;
            throw new ResultSetException("Expected only object keys " + Arrays.asList(keys) + " but encountered '" + k + "'");
        }
    }
}

