/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.web;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.openjena.atlas.web.HttpException;
import org.openjena.atlas.web.MediaType;
import org.openjena.riot.web.ContentProducer;
import org.openjena.riot.web.HttpResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOp {
    private static Logger log = LoggerFactory.getLogger(HttpOp.class);
    private static AtomicLong counter = new AtomicLong(0L);

    public static void execHttpGet(String url, String acceptHeader, Map<String, HttpResponseHandler> handlers) {
        try {
            long id = counter.incrementAndGet();
            String requestURI = HttpOp.determineRequestURI(url);
            String baseIRI = HttpOp.determineBaseIRI(requestURI);
            HttpGet httpget = new HttpGet(requestURI);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, httpget.getMethod(), httpget.getURI().toString()));
            }
            if (acceptHeader != null) {
                httpget.addHeader("Accept", acceptHeader);
            }
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpOp.httpResponse(id, response, baseIRI, handlers);
            httpclient.getConnectionManager().shutdown();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void execHttpPost(String url, String contentType, String content) {
        HttpOp.execHttpPost(url, contentType, content, null, null);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, int length) {
        HttpOp.execHttpPost(url, contentType, input, length, null, null);
    }

    public static void execHttpPost(String url, String contentType, String content, String acceptType, Map<String, HttpResponseHandler> handlers) {
        StringEntity e2 = null;
        try {
            e2 = new StringEntity(content, "UTF-8");
            e2.setContentType(contentType);
            HttpOp.execHttpPost(url, (HttpEntity)e2, acceptType, handlers);
        }
        catch (UnsupportedEncodingException e1) {
            try {
                throw new ARQInternalErrorException("Platform does not support required UTF-8");
            }
            catch (Throwable throwable) {
                HttpOp.closeEntity(e2);
                throw throwable;
            }
        }
        HttpOp.closeEntity((HttpEntity)e2);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, int length, String acceptType, Map<String, HttpResponseHandler> handlers) {
        InputStreamEntity e2 = new InputStreamEntity(input, (long)length);
        e2.setContentType(contentType);
        e2.setContentEncoding("UTF-8");
        HttpOp.execHttpPost(url, (HttpEntity)e2, acceptType, handlers);
    }

    public static void execHttpPost(String url, String contentType, ContentProducer provider, String acceptType, Map<String, HttpResponseHandler> handlers) {
        EntityTemplate entity = new EntityTemplate((org.apache.http.entity.ContentProducer)provider);
        entity.setContentType(contentType);
        HttpOp.execHttpPost(url, (HttpEntity)entity, acceptType, handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPost(String url, HttpEntity provider, String acceptType, Map<String, HttpResponseHandler> handlers) {
        try {
            long id = counter.incrementAndGet();
            String requestURI = HttpOp.determineBaseIRI(url);
            String baseIRI = HttpOp.determineBaseIRI(requestURI);
            HttpPost httppost = new HttpPost(requestURI);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, httppost.getMethod(), httppost.getURI().toString()));
            }
            if (provider.getContentType() == null) {
                log.debug(String.format("[%d] No content type", new Object[0]));
            }
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httppost.setEntity(provider);
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpOp.httpResponse(id, response, baseIRI, handlers);
            httpclient.getConnectionManager().shutdown();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            HttpOp.closeEntity(provider);
        }
    }

    private static void closeEntity(HttpEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            entity.getContent().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String determineRequestURI(String url) {
        String requestURI = url;
        if (requestURI.contains("#")) {
            int i = requestURI.indexOf(35);
            requestURI = requestURI.substring(0, i);
        }
        return requestURI;
    }

    private static String determineBaseIRI(String requestURI) {
        String baseIRI = requestURI;
        if (requestURI.contains("?")) {
            int i = requestURI.indexOf(63);
            baseIRI = requestURI.substring(0, i);
        }
        return baseIRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void httpResponse(long id, HttpResponse response, String baseIRI, Map<String, HttpResponseHandler> handlers) throws IllegalStateException, IOException {
        if (response == null) {
            return;
        }
        try {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 400) {
                log.debug(String.format("[%d] %s %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                throw new HttpException(statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
            }
            String ct = "*";
            MediaType mt = null;
            if (statusLine.getStatusCode() == 200) {
                HttpResponseHandler handler;
                String contentType = response.getFirstHeader("Content-Type").getValue();
                if (contentType != null) {
                    mt = new MediaType(contentType);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("[%d] %d %s :: %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase(), mt));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug(String.format("[%d] %d %s :: (no content type)", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                }
                if ((handler = handlers.get(ct)) == null) {
                    handler = handlers.get("*");
                }
                if (handler != null) {
                    handler.handle(ct, baseIRI, response);
                } else {
                    log.warn(String.format("[%d] No handler found for %s", id, ct));
                }
            } else if (handlers != null) {
                log.warn(String.format("[%d] No content returned but handlers provided", new Object[0]));
            }
        }
        finally {
            HttpOp.closeEntity(response.getEntity());
        }
    }
}

