/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;

public class AggCountVar
extends AggregatorBase {
    private Expr expr;

    public AggCountVar(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Aggregator copy(Expr expr) {
        return new AggCountVar(expr);
    }

    @Override
    public String toString() {
        return "count(" + this.expr + ")";
    }

    @Override
    public String toPrefixString() {
        return "(count " + this.expr + ")";
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCountVar(this.expr);
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.expr.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AggCountVar)) {
            return false;
        }
        AggCountVar agg = (AggCountVar)other;
        return agg.getExpr().equals(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    private static class AccCountVar
    extends AccumulatorExpr {
        private long count = 0L;

        public AccCountVar(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getValue() {
            return this.getAccValue();
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

