/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.sparql.graph.SmallGraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.Iterator;

public class PlainGraphMem
extends SmallGraphMem {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean graphBaseContains(Triple t) {
        if (t.isConcrete()) {
            return this.triples.contains(t);
        }
        ExtendedIterator it = this.find((TripleMatch)t);
        try {
            while (it.hasNext()) {
                Triple t2 = (Triple)it.next();
                if (!PlainGraphMem.tripleContained(t, t2)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            it.close();
        }
        return false;
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        Iterator iter = this.triples.iterator();
        return SimpleEventManager.notifyingRemove((Graph)this, iter).filterKeep((Filter)new TripleMatchFilterEquality(m.asTriple()));
    }

    static boolean tripleContained(Triple patternTriple, Triple dataTriple) {
        return PlainGraphMem.equalNode(patternTriple.getSubject(), dataTriple.getSubject()) && PlainGraphMem.equalNode(patternTriple.getPredicate(), dataTriple.getPredicate()) && PlainGraphMem.equalNode(patternTriple.getObject(), dataTriple.getObject());
    }

    private static boolean equalNode(Node m, Node n) {
        n = PlainGraphMem.fixupNode(n);
        return (m = PlainGraphMem.fixupNode(m)) == null || m == Node.ANY || m.equals((Object)n);
    }

    private static Node fixupNode(Node node) {
        String lang;
        if (node == null || node == Node.ANY) {
            return node;
        }
        if (node.isLiteral() && (lang = node.getLiteralLanguage()) != null && !lang.equals("")) {
            node = Node.createLiteral((String)node.getLiteralLexicalForm(), (String)lang.toLowerCase(), (RDFDatatype)node.getLiteralDatatype());
        }
        return node;
    }

    static class TripleMatchFilterEquality
    extends Filter<Triple> {
        protected final Triple tMatch;

        public TripleMatchFilterEquality(Triple tMatch) {
            this.tMatch = tMatch;
        }

        public boolean accept(Triple t) {
            return PlainGraphMem.tripleContained(this.tMatch, t);
        }
    }
}

