/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.resultset.TSVInput;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.IndentedWriter;

public class TSVInputIterator
extends QueryIteratorBase {
    private BufferedReader reader;
    private BindingMap binding;
    private int expectedItems;
    private List<Var> vars;

    public TSVInputIterator(BufferedReader reader, List<Var> vars) {
        this.reader = reader;
        this.expectedItems = vars.size();
        this.vars = vars;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println("TSVInputIterator");
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.reader != null) {
            if (this.binding == null) {
                return this.parseNextBinding();
            }
            return true;
        }
        return false;
    }

    private boolean parseNextBinding() {
        String line;
        try {
            line = this.reader.readLine();
            if (line == null) {
                return false;
            }
        }
        catch (IOException e2) {
            throw new QueryException("Error parsing TSV results - " + e2.getMessage());
        }
        if (line.isEmpty()) {
            if (this.expectedItems > 1) {
                throw new QueryException(String.format("Error Parsing TSV results - A result row had 0/1 values when %d were expected", this.expectedItems));
            }
            this.binding = BindingFactory.create();
            return true;
        }
        String[] tokens2 = TSVInput.pattern.split(line, -1);
        if (tokens2.length != this.expectedItems) {
            throw new QueryException(String.format("Error Parsing TSV results - A result row had %d values instead of the expected %d.", tokens2.length, this.expectedItems));
        }
        this.binding = BindingFactory.create();
        for (int i = 0; i < tokens2.length; ++i) {
            String token = tokens2[i];
            if (token.equals("")) continue;
            Node node = NodeFactory.parseNode(token, null);
            this.binding.add(this.vars.get(i), node);
        }
        return true;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BindingMap b = this.binding;
        this.binding = null;
        return b;
    }

    @Override
    protected void closeIterator() {
        IO.close(this.reader);
        this.reader = null;
    }

    @Override
    protected void requestCancel() {
    }
}

