/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openjena.atlas.logging.Log;
import org.openjena.atlas.web.MediaRange;
import org.openjena.atlas.web.MediaType;

public class AcceptList {
    private List<MediaRange> ranges;
    private static final MediaRangeCompare comparator = new MediaRangeCompare();

    private AcceptList() {
        this.ranges = new ArrayList<MediaRange>();
    }

    public AcceptList(List<MediaRange> mediaRanges) {
        this.ranges = new ArrayList<MediaRange>(mediaRanges);
    }

    public AcceptList(MediaRange ... acceptItems) {
        this.ranges = Arrays.asList(acceptItems);
    }

    public AcceptList(MediaType ... acceptItems) {
        this.ranges = new ArrayList<MediaRange>();
        for (MediaType mtype : acceptItems) {
            this.ranges.add(new MediaRange(mtype));
        }
    }

    public AcceptList(String ... acceptStrings) {
        this.ranges = new ArrayList<MediaRange>();
        for (int i = 0; i < acceptStrings.length; ++i) {
            this.ranges.add(new MediaRange(acceptStrings[i]));
        }
    }

    public AcceptList(String headerString) {
        try {
            this.ranges = AcceptList.stringToAcceptList(headerString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            Log.warn(this, "Unrecognized accept string (ignored): " + headerString);
            this.ranges = new ArrayList<MediaRange>();
        }
    }

    private boolean accepts(MediaRange aItem) {
        return this.match(aItem) != null;
    }

    private List<MediaRange> entries() {
        return Collections.unmodifiableList(this.ranges);
    }

    public MediaRange match(MediaRange aItem) {
        MediaRange choice = null;
        for (MediaRange acceptItem : this.ranges) {
            if (!acceptItem.accepts(aItem) || choice != null && choice.get_q() >= acceptItem.get_q()) continue;
            if (aItem.moreGroundedThan(acceptItem)) {
                acceptItem = new MediaRange(acceptItem);
                acceptItem.setType(aItem.getType());
                acceptItem.setSubType(aItem.getSubType());
            }
            choice = acceptItem;
        }
        return choice;
    }

    public static MediaType match(AcceptList proposalList, AcceptList offerList) {
        MediaRange choice = null;
        for (MediaRange offer : offerList.entries()) {
            MediaRange m = proposalList.match(offer);
            if (m == null || choice != null && choice.get_q() >= m.get_q()) continue;
            choice = m;
        }
        if (choice == null) {
            return null;
        }
        return new MediaType(choice);
    }

    public MediaRange first() {
        MediaRange choice = null;
        for (MediaRange acceptItem : this.ranges) {
            if (choice != null && choice.get_q() >= acceptItem.get_q()) continue;
            choice = acceptItem;
        }
        return choice;
    }

    public String toString() {
        return this.ranges.toString();
    }

    private static List<MediaRange> stringToAcceptList(String s) {
        ArrayList<MediaRange> ranges = new ArrayList<MediaRange>();
        if (s == null) {
            return ranges;
        }
        String[] x = s.split(",");
        for (int i = 0; i < x.length; ++i) {
            if (x[i].equals("")) continue;
            MediaRange mType = new MediaRange(x[i]);
            ranges.add(mType);
        }
        return ranges;
    }

    private static class MediaRangeCompare
    implements Comparator<MediaRange> {
        private MediaRangeCompare() {
        }

        @Override
        public int compare(MediaRange mType1, MediaRange mType2) {
            int r = Double.compare(mType1.get_q(), mType2.get_q());
            if (r == 0) {
                r = this.subCompare(mType1.getType(), mType2.getType());
            }
            if (r == 0) {
                r = this.subCompare(mType1.getSubType(), mType2.getSubType());
            }
            r = -r;
            return r;
        }

        public int subCompare(String a, String b) {
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            if (a.equals("*") && b.equals("*")) {
                return 0;
            }
            if (a.equals("*")) {
                return -1;
            }
            if (b.equals("*")) {
                return 1;
            }
            return 0;
        }
    }
}

