/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

public class ContentType {
    private static String nameCharset = "charset";
    private final String contentType;
    private final String charset;
    private final String dftCharset;

    public static ContentType parse(String x) {
        if (x == null) {
            return null;
        }
        String[] y = x.split(";");
        if (y.length == 0) {
            return null;
        }
        String contentType = null;
        if (y[0] != null) {
            contentType = y[0].trim();
        }
        String charset = null;
        if (y.length == 2 && y[1] != null && y[1].contains("=")) {
            String[] z = y[1].split("=");
            z[0] = z[0].trim();
            if (z[0].toLowerCase().startsWith(nameCharset)) {
                charset = z[1].trim();
            }
        }
        if (contentType != null) {
            contentType = contentType.toLowerCase();
        }
        if (charset != null) {
            charset = charset.toLowerCase();
        }
        return new ContentType(contentType, charset, null);
    }

    public static ContentType createConst(String contentType, String dftCharset) {
        return new ContentType(contentType, null, dftCharset);
    }

    public static ContentType create(String contentType, String charset) {
        return new ContentType(contentType, charset, null);
    }

    public static ContentType create(String contentType) {
        return new ContentType(contentType, null, null);
    }

    private ContentType(String contentType, String charset, String dftCharset) {
        this.contentType = contentType.toLowerCase();
        this.charset = charset;
        this.dftCharset = dftCharset;
    }

    public String toString() {
        String x = this.contentType;
        if (this.charset != null) {
            x = x + ";" + nameCharset + "=" + this.charset;
        }
        return x;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getDftCharset() {
        return this.dftCharset;
    }
}

