/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.logging.Log;

public abstract class CmdMain
extends CmdLineArgs {
    public CmdMain(String[] args) {
        super(args);
    }

    public void mainRun() {
        this.mainRun(false, true);
    }

    public void mainRun(boolean exitOnFailure) {
        this.mainRun(exitOnFailure, true);
    }

    public void mainAndExit() {
        this.mainRun(true, true);
    }

    public int mainRun(boolean exitOnSuccess, boolean exitOnFailure) {
        try {
            this.mainMethod();
        }
        catch (TerminationException ex) {
            System.exit(ex.getCode());
        }
        catch (JenaException ex) {
            ex.printStackTrace(System.err);
            String s = Utils.className((Object)ex);
            if (exitOnFailure) {
                System.exit(2);
            }
            return 2;
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            if (exitOnFailure) {
                System.exit(1);
            }
            return 1;
        }
        catch (CmdException ex) {
            if (ex.getMessage() != null && ex.getMessage().length() > 0) {
                System.err.println(ex.getMessage());
            }
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace(System.err);
            }
            if (exitOnFailure) {
                System.exit(1);
            }
            return 1;
        }
        if (exitOnSuccess) {
            System.exit(0);
        }
        return 0;
    }

    protected final void mainMethod() {
        this.process();
        this.exec();
    }

    protected abstract void exec();

    protected abstract String getCommandName();

    public void cmdError(String msg) {
        this.cmdError(msg, true);
    }

    public void cmdError(String msg, boolean exit) {
        System.err.println(msg);
        if (exit) {
            throw new TerminationException(5);
        }
    }

    static {
        Log.setCmdLogging();
    }
}

