/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.resultset.CSVInputIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.openjena.atlas.io.IO;

public class CSVInput {
    public static ResultSet fromCSV(InputStream in) {
        BufferedReader reader = IO.asBufferedUTF8(in);
        ArrayList<Var> vars = new ArrayList<Var>();
        ArrayList<String> varNames = new ArrayList<String>();
        boolean first = true;
        String str2 = null;
        try {
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("CSV Results malformed - input is empty (no header row)");
            }
            if (!str2.isEmpty()) {
                String[] tokens2;
                for (String token : tokens2 = str2.split(",")) {
                    if (token.startsWith("?")) {
                        token = token.substring(1);
                    }
                    Var var = Var.alloc(token);
                    vars.add(var);
                    varNames.add(var.getName());
                }
            }
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
        return new ResultSetStream(varNames, null, new CSVInputIterator(reader, vars));
    }
}

