/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openjena.atlas.lib.ActionKeyValue;

class CacheImpl<K, V>
extends LinkedHashMap<K, V> {
    int maxEntries;
    ActionKeyValue<K, V> dropHandler = null;

    public CacheImpl(int maxSize) {
        this(0.75f, maxSize);
    }

    public CacheImpl(float loadFactor, int maxSize) {
        super(Math.round((float)maxSize / loadFactor + 0.5f) + 1, loadFactor, true);
        this.maxEntries = maxSize;
    }

    public void setDropHandler(ActionKeyValue<K, V> dropHandler) {
        this.dropHandler = dropHandler;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean b;
        boolean bl = b = this.size() > this.maxEntries;
        if (b && this.dropHandler != null) {
            this.dropHandler.apply(eldest.getKey(), eldest.getValue());
        }
        return b;
    }
}

