/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.resultset.CSVInputIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.openjena.atlas.io.IO;

public class CSVInput {
    public static ResultSet fromCSV(InputStream in) {
        BufferedReader reader = IO.asBufferedUTF8(in);
        ArrayList<Var> vars = new ArrayList<Var>();
        ArrayList<String> varNames = new ArrayList<String>();
        String str2 = null;
        try {
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("CSV Results malformed, input is empty (no header row)");
            }
            if (!str2.isEmpty()) {
                String[] tokens2;
                for (String token : tokens2 = str2.split(",")) {
                    Var var = Var.alloc(token);
                    vars.add(var);
                    varNames.add(var.getName());
                }
            }
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
        return new ResultSetStream(varNames, null, new CSVInputIterator(reader, vars));
    }

    public static boolean booleanFromCSV(InputStream in) {
        BufferedReader reader = IO.asBufferedUTF8(in);
        String str2 = null;
        try {
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("CSV Boolean Results malformed, input is empty");
            }
            if (!(str2 = str2.trim()).equals("_askResult")) {
                throw new ARQException("CSV Boolean Results malformed, did not get expected ?_askResult header row");
            }
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("CSV Boolean Results malformed, unexpected end of input after header row");
            }
            if ((str2 = str2.trim()).toLowerCase().equals("true") || str2.toLowerCase().equals("yes")) {
                return true;
            }
            if (str2.toLowerCase().equals("false") || str2.toLowerCase().equals("no")) {
                return false;
            }
            throw new ARQException("CSV Boolean Results malformed, expected one of - true yes false no - but got " + str2);
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }
}

