/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import org.openjena.atlas.iterator.Filter;

public abstract class FilterStack<T>
implements Filter<T> {
    private final Filter<T> other;
    private final boolean subFilterLast;

    public FilterStack(Filter<T> other) {
        this(other, false);
    }

    public FilterStack(Filter<T> other, boolean callOldFilterFirst) {
        this.other = other;
        this.subFilterLast = callOldFilterFirst;
    }

    @Override
    public final boolean accept(T item) {
        if (this.subFilterLast) {
            return this.acceptAdditionaOther(item);
        }
        return this.acceptOtherAdditional(item);
    }

    private boolean acceptAdditionaOther(T item) {
        if (!this.acceptAdditional(item)) {
            return false;
        }
        return this.other == null || this.other.accept(item);
    }

    private boolean acceptOtherAdditional(T item) {
        if (this.other != null && !this.other.accept(item)) {
            return false;
        }
        return !this.acceptAdditional(item);
    }

    public abstract boolean acceptAdditional(T var1);
}

