/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.util.FileUtils;
import org.openjena.riot.RiotException;
import org.openjena.riot.WebContent;

public enum Lang {
    RDFXML("RDF/XML", true, new String[]{"rdf", "owl", "xml"}, "RDF/XML", "RDF/XML-ABBREV"),
    NTRIPLES("N-Triples", true, new String[]{"nt"}, "N-TRIPLES", "N-TRIPLE"),
    N3("N3", true, new String[]{"n3"}, new String[0]),
    TURTLE("Turtle", true, new String[]{"ttl"}, "TTL"),
    RDFJSON("RDF/JSON", true, new String[]{"rj", "json"}, new String[0]),
    NQUADS("N-Quads", false, new String[]{"nq"}, "NQUADS"),
    TRIG("TriG", false, new String[]{"trig"}, new String[0]);

    private final String name;
    private final boolean isTriples;
    private final String[] altNames;
    private final String[] fileExtensions;

    private Lang(String name, boolean isTriples, String[] fileExtensions, String ... altNames) {
        this.name = name;
        this.isTriples = isTriples;
        this.altNames = altNames;
        this.fileExtensions = fileExtensions;
    }

    public String getName() {
        return this.name;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public String getDefaultFileExtension() {
        if (this.getFileExtensions() == null) {
            return null;
        }
        return this.getFileExtensions()[0];
    }

    public boolean isTriples() {
        return this.isTriples;
    }

    public boolean isQuads() {
        return !this.isTriples;
    }

    public String getContentType() {
        return WebContent.mapLangToContentType(this);
    }

    public String toString() {
        return "lang:" + this.name;
    }

    public static Lang get(String name) {
        Lang lang = Lang.get(name, null);
        if (lang == null) {
            throw new RiotException("No such language: " + name);
        }
        return lang;
    }

    public static Lang get(String name, Lang dftLang) {
        for (Lang l : Lang.values()) {
            if (!Lang.matchesLangName(name, l)) continue;
            return l;
        }
        return dftLang;
    }

    private static boolean matchesLangName(String name, Lang lang) {
        if (name.equalsIgnoreCase(lang.name)) {
            return true;
        }
        if (lang.altNames != null) {
            for (String x : lang.altNames) {
                if (!x.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Lang guess(String resourceIRI, Lang dftLang) {
        Lang lang = Lang.guess(resourceIRI);
        if (lang != null) {
            return lang;
        }
        return dftLang;
    }

    public static Lang guess(String resourceIRI) {
        if (resourceIRI == null) {
            return null;
        }
        String ext = FileUtils.getFilenameExt((String)resourceIRI).toLowerCase();
        if (ext != null && ext.equals("gz")) {
            resourceIRI = resourceIRI.substring(0, resourceIRI.length() - ".gz".length());
            ext = FileUtils.getFilenameExt((String)resourceIRI).toLowerCase();
        }
        for (Lang lang : Lang.values()) {
            if (!Lang.isOneOf(ext, lang.fileExtensions)) continue;
            return lang;
        }
        return null;
    }

    private static boolean isOneOf(String ext, String[] names) {
        for (String x : names) {
            if (!ext.equals(x)) continue;
            return true;
        }
        return false;
    }
}

