/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdUpdate;
import java.util.Iterator;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.graph.GraphLoadMonitor;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateRequest;

public class load
extends CmdUpdate {
    private static final ArgDecl graphNameArg = new ArgDecl(true, new String[]{"--graph"});
    private static final ArgDecl dumpArg = new ArgDecl(false, new String[]{"--dump"});
    String graphName = null;
    List<String> loadFiles = null;
    boolean dump = false;

    public static void main(String ... argv) {
        new load(argv).mainRun();
    }

    protected load(String[] argv) {
        super(argv);
        super.add(graphNameArg, "--graph=IRI", "Graph IRI (loads default graph if absent)");
        super.add(dumpArg, "--dump", "Dump the resulting graph store");
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.containsMultiple(graphNameArg)) {
            throw new CmdException("At most one --graph allowed");
        }
        this.graphName = this.getValue(graphNameArg);
        this.loadFiles = super.getPositional();
        this.dump = this.contains(dumpArg);
        super.processModulesAndArgs();
    }

    @Override
    protected String getCommandName() {
        return Lib.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    @Override
    protected void execUpdate(DatasetGraph graphStore) {
        if (this.loadFiles.size() == 0) {
            throw new CmdException("Nothing to do");
        }
        UpdateRequest req = new UpdateRequest();
        for (String filename : this.loadFiles) {
            UpdateLoad loadReq = new UpdateLoad(filename, this.graphName);
            req.add(loadReq);
        }
        this.monitor(graphStore.getDefaultGraph());
        Iterator<Node> iter = graphStore.listGraphNodes();
        while (iter.hasNext()) {
            Graph g = graphStore.getGraph(iter.next());
            this.monitor(g);
        }
        UpdateExecutionFactory.create(req, graphStore).execute();
        if (this.dump) {
            IndentedWriter out = IndentedWriter.stdout;
            SSE.write(graphStore);
            out.flush();
        }
    }

    private void monitor(Graph graph) {
        GraphLoadMonitor m = new GraphLoadMonitor(20000, false);
        graph.getEventManager().register((GraphListener)m);
    }
}

