/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.DatasetUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.FileManager;

public class DatasetFactory {
    public static Dataset createMem() {
        return DatasetFactory.create(DatasetGraphFactory.createMem());
    }

    public static Dataset createMemFixed() {
        return DatasetFactory.create(DatasetGraphFactory.createMemFixed());
    }

    public static Dataset create(Model model) {
        return new DatasetImpl(model);
    }

    public static Dataset create(Dataset dataset) {
        return new DatasetImpl(dataset);
    }

    public static Dataset create(DatasetGraph dataset) {
        return DatasetImpl.wrap(dataset);
    }

    public static Dataset create(List<String> uriList) {
        return DatasetFactory.create(uriList, null, null);
    }

    public static Dataset create(String uri) {
        return DatasetFactory.create(uri, null, null);
    }

    public static Dataset createNamed(List<String> namedSourceList) {
        return DatasetFactory.create((List<String>)null, namedSourceList, null);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList) {
        return DatasetFactory.create(uriList, namedSourceList, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList) {
        return DatasetFactory.create(uri, namedSourceList, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList, String baseURI) {
        return DatasetUtils.createDataset(uri, namedSourceList, baseURI);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList, String baseURI) {
        return DatasetUtils.createDataset(uriList, namedSourceList, baseURI);
    }

    public static Dataset make(Dataset ds, Model defaultModel) {
        DatasetImpl ds2 = new DatasetImpl(ds);
        ds2.setDefaultModel(defaultModel);
        return ds2;
    }

    public static Dataset assemble(String filename) {
        Model model = FileManager.get().loadModel(filename);
        return DatasetFactory.assemble(model);
    }

    public static Dataset assemble(String filename, String resourceURI) {
        Model model = FileManager.get().loadModel(filename);
        Resource r = model.createResource(resourceURI);
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Model model) {
        Resource r = GraphUtils.findRootByType(model, DatasetAssembler.getType());
        if (r == null) {
            throw new ARQException("No root found for type <" + DatasetAssembler.getType() + ">");
        }
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Resource resource) {
        Dataset ds = (Dataset)Assembler.general.open(resource);
        return ds;
    }
}

