/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql;

import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ARQConstants {
    public static final String fnPrefix = "http://www.w3.org/2005/xpath-functions#";
    public static final String rdfPrefix = RDF.getURI();
    public static final String rdfsPrefix = RDFS.getURI();
    public static final String owlPrefix = OWL.getURI();
    public static final String xsdPrefix = "http://www.w3.org/2001/XMLSchema#";
    public static final String fnSparql = "http://www.w3.org/ns/sparql#";
    public static final String srxPrefix = "http://www.w3.org/2005/sparql-results#";
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema#";
    public static final String javaClassURIScheme = "java:";
    public static final String ARQFunctionLibraryURI = "http://jena.apache.org/ARQ/function#";
    @Deprecated
    public static final String ARQFunctionLibraryURI_Jena2 = "http://jena.hpl.hp.com/ARQ/function#";
    public static final String ARQPropertyFunctionLibraryURI = "http://jena.apache.org/ARQ/property#";
    @Deprecated
    public static final String ARQPropertyFunctionLibraryURI_Jena2 = "http://jena.hpl.hp.com/ARQ/property#";
    public static final String ARQProcedureLibraryURI = "http://jena.apache.org/ARQ/procedure#";
    public static final String ARQFunctionLibrary = "java:org.apache.jena.sparql.function.library.";
    public static final String ARQPropertyFunctionLibrary = "java:org.apache.jena.sparql.pfunction.library.";
    public static final String ARQProcedureLibrary = "java:org.apache.jena.sparql.procedure.library.";
    protected static final PrefixMapping globalPrefixMap = new PrefixMappingImpl();
    public static final String allocVarAnonMarker = "?";
    public static final String allocVarMarker = ".";
    private static final String globalVar = ".";
    public static final String allocVarBNodeToVar = "~";
    public static final String allocVarScopeHiding = "/";
    public static final String allocVarQuad = "*g";
    public static final String allocGlobalVarMarker = "..";
    public static final String allocPathVariables = "?P";
    public static final String allocQueryVariables = ".";
    public static final String allocParserAnonVars = "?";
    public static final String allocSSEUnamedVars = "_";
    public static final String allocSSEAnonVars = "?";
    public static final String allocSSENamedVars = ".";
    public static final String systemVarNS = "http://jena.apache.org/ARQ/system#";
    public static final Symbol sysCurrentQuery;
    public static final Symbol sysOpExecutorFactory;
    public static final Symbol sysOptimizerFactory;
    public static final Symbol sysOptimizer;
    public static final Symbol sysCurrentDataset;
    public static final Symbol sysDatasetDescription;
    public static final Symbol sysCurrentAlgebra;
    public static final Symbol sysCurrentTime;
    public static final Symbol sysVersionARQ;
    public static final Symbol sysVersionJena;
    public static final Symbol sysVarAllocNamed;
    public static final Symbol sysVarAllocAnon;
    public static final Symbol symDatasetDefaultGraphs;
    public static final Symbol symDatasetNamedGraphs;
    public static final Symbol autoDistinct;
    public static final Symbol registryPropertyFunctions;
    public static final Symbol registryDescribeHandlers;
    public static final Symbol registryFunctions;
    public static final Symbol registryProcedures;
    public static final Symbol registryExtensions;

    public static PrefixMapping getGlobalPrefixMap() {
        return globalPrefixMap;
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith("arq")) {
            throw new ARQInternalErrorException("Symbol short name begins with the ARQ namespace prefix: " + shortName);
        }
        if (shortName.startsWith("http:")) {
            throw new ARQInternalErrorException("Symbol short name begins with http: " + shortName);
        }
        return ARQConstants.allocSymbol("http://jena.apache.org/ARQ#", shortName);
    }

    public static Symbol allocSymbol(String base, String shortName) {
        return Symbol.create(base + shortName);
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", rdfPrefix);
        globalPrefixMap.setNsPrefix("rdfs", rdfsPrefix);
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("owl", owlPrefix);
        globalPrefixMap.setNsPrefix("fn", fnPrefix);
        globalPrefixMap.setNsPrefix("afn", ARQFunctionLibraryURI);
        globalPrefixMap.setNsPrefix("apf", ARQPropertyFunctionLibraryURI);
        sysCurrentQuery = Symbol.create("http://jena.apache.org/ARQ/system#query");
        sysOpExecutorFactory = Symbol.create("http://jena.apache.org/ARQ/system#opExecutorFactory");
        sysOptimizerFactory = Symbol.create("http://jena.apache.org/ARQ/system#optimizerFactory");
        sysOptimizer = Symbol.create("http://jena.apache.org/ARQ/system#optimizer");
        sysCurrentDataset = Symbol.create("http://jena.apache.org/ARQ/system#dataset");
        sysDatasetDescription = Symbol.create("http://jena.apache.org/ARQ/system#datasetDescription");
        sysCurrentAlgebra = Symbol.create("http://jena.apache.org/ARQ/system#algebra");
        sysCurrentTime = Symbol.create("http://jena.apache.org/ARQ/system#now");
        sysVersionARQ = Symbol.create("http://jena.apache.org/ARQ/system#version/ARQ");
        sysVersionJena = Symbol.create("http://jena.apache.org/ARQ/system#version/Jena");
        sysVarAllocNamed = Symbol.create("http://jena.apache.org/ARQ/system#namedVarAlloc");
        sysVarAllocAnon = Symbol.create("http://jena.apache.org/ARQ/system#namedVarAnon");
        symDatasetDefaultGraphs = ARQConstants.allocSymbol("datasetDefaultGraphs");
        symDatasetNamedGraphs = ARQConstants.allocSymbol("datasetNamedGraphs");
        autoDistinct = ARQConstants.allocSymbol("autoDistinct");
        registryPropertyFunctions = ARQConstants.allocSymbol("registryPropertyFunctions");
        registryDescribeHandlers = ARQConstants.allocSymbol("registryDescribeHandlers");
        registryFunctions = ARQConstants.allocSymbol("registryFunctions");
        registryProcedures = ARQConstants.allocSymbol("registryProcedures");
        registryExtensions = ARQConstants.allocSymbol("registryExtensions");
    }
}

