/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.Table1;
import org.apache.jena.sparql.algebra.table.TableEmpty;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;

public class TableFactory {
    public static Table createUnit() {
        return new TableUnit();
    }

    public static Table createEmpty() {
        return new TableEmpty();
    }

    public static Table create() {
        return new TableN();
    }

    public static Table create(List<Var> vars) {
        return new TableN(vars);
    }

    public static Table create(QueryIterator queryIterator) {
        if (queryIterator instanceof QueryIterRoot) {
            queryIterator.close();
            return TableFactory.createUnit();
        }
        return new TableN(queryIterator);
    }

    public static Table create(Var var, Node value) {
        return new Table1(var, value);
    }
}

