/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraphBase;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.Quad;

public abstract class DatasetGraphCaching
extends DatasetGraphTriplesQuads {
    private final boolean caching = true;
    private boolean closed = false;
    protected Graph defaultGraph = null;
    protected Cache<Node, Graph> namedGraphs = CacheFactory.createCache((int)100);

    protected abstract void _close();

    protected abstract Graph _createNamedGraph(Node var1);

    protected abstract Graph _createDefaultGraph();

    protected abstract boolean _containsGraph(Node var1);

    protected DatasetGraphCaching() {
        this(100);
    }

    protected DatasetGraphCaching(int cacheSize) {
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("Cache size is less that 1: " + cacheSize);
        }
        this.namedGraphs = CacheFactory.createCache((int)cacheSize);
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        if (this.namedGraphs.containsKey((Object)graphNode)) {
            return true;
        }
        return this._containsGraph(graphNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Graph getDefaultGraph() {
        DatasetGraphCaching datasetGraphCaching = this;
        synchronized (datasetGraphCaching) {
            if (this.defaultGraph == null) {
                this.defaultGraph = this._createDefaultGraph();
            }
        }
        return this.defaultGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Graph getGraph(final Node graphNode) {
        DatasetGraphCaching datasetGraphCaching = this;
        synchronized (datasetGraphCaching) {
            Callable<Graph> filler = new Callable<Graph>(){

                @Override
                public Graph call() {
                    return DatasetGraphCaching.this._createNamedGraph(graphNode);
                }
            };
            Graph graph = (Graph)this.namedGraphs.getOrFill((Object)graphNode, (Callable)filler);
            return graph;
        }
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.removeGraph(graphName);
        GraphUtil.addInto((Graph)this.getGraph(graphName), (Graph)graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeGraph(Node graphName) {
        this.deleteAny(graphName, Node.ANY, Node.ANY, Node.ANY);
        DatasetGraphCaching datasetGraphCaching = this;
        synchronized (datasetGraphCaching) {
            this.namedGraphs.remove((Object)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DatasetGraphCaching datasetGraphCaching = this;
        synchronized (datasetGraphCaching) {
            super.clear();
            this.namedGraphs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DatasetGraphCaching datasetGraphCaching = this;
        synchronized (datasetGraphCaching) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.defaultGraph = null;
            this.namedGraphs.clear();
            this._close();
            super.close();
        }
    }

    protected static class Helper {
        protected Helper() {
        }

        public static void addToDftGraph(DatasetGraphCaching dsg, Node s, Node p, Node o) {
            dsg.getDefaultGraph().add(new Triple(s, p, o));
        }

        public static void addToNamedGraph(DatasetGraphCaching dsg, Node g, Node s, Node p, Node o) {
            dsg.getGraph(g).add(new Triple(s, p, o));
        }

        public static void deleteFromDftGraph(DatasetGraphCaching dsg, Node s, Node p, Node o) {
            dsg.getDefaultGraph().delete(new Triple(s, p, o));
        }

        public static void deleteFromNamedGraph(DatasetGraphCaching dsg, Node g, Node s, Node p, Node o) {
            dsg.getGraph(g).delete(new Triple(s, p, o));
        }

        public static Iterator<Quad> findInAnyNamedGraphs(DatasetGraphCaching dsg, Node s, Node p, Node o) {
            Iterator<Node> iter = dsg.listGraphNodes();
            Iterator quads = null;
            while (iter.hasNext()) {
                Node gn = iter.next();
                quads = Iter.append(quads, Helper.findInSpecificNamedGraph(dsg, gn, s, p, o));
            }
            return quads;
        }

        public static Iterator<Quad> findInDftGraph(DatasetGraphCaching dsg, Node s, Node p, Node o) {
            return DatasetGraphBase.triples2quadsDftGraph((Iterator<Triple>)dsg.getDefaultGraph().find(s, p, o));
        }

        public static Iterator<Quad> findInSpecificNamedGraph(DatasetGraphCaching dsg, Node g, Node s, Node p, Node o) {
            return DatasetGraphBase.triples2quadsDftGraph((Iterator<Triple>)dsg.getGraph(g).find(s, p, o));
        }
    }
}

