/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMaker;
import org.apache.jena.sparql.core.DatasetGraphMap;
import org.apache.jena.sparql.core.DatasetGraphOne;
import org.apache.jena.sparql.graph.GraphFactory;

public class DatasetGraphFactory {
    public static GraphMaker graphMakerNull = new GraphMaker(){

        @Override
        public Graph create() {
            return null;
        }
    };
    private static GraphMaker memGraphMaker = new GraphMaker(){

        @Override
        public Graph create() {
            return GraphFactory.createDefaultGraph();
        }
    };

    public static DatasetGraph create(DatasetGraph dsg) {
        return new DatasetGraphMap(dsg);
    }

    private static void copyOver(DatasetGraph dsgDest, DatasetGraph dsgSrc) {
        dsgDest.setDefaultGraph(dsgSrc.getDefaultGraph());
        Iterator<Node> names = dsgSrc.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dsgDest.addGraph(gn, dsgSrc.getGraph(gn));
        }
    }

    public static DatasetGraph create(Graph graph) {
        DatasetGraph dsg2 = DatasetGraphFactory.createMemFixed();
        dsg2.setDefaultGraph(graph);
        return dsg2;
    }

    public static DatasetGraph createOneGraph(Graph graph) {
        return new DatasetGraphOne(graph);
    }

    public static DatasetGraph createMem() {
        return new DatasetGraphMaker(memGraphMaker);
    }

    public static DatasetGraph createMemFixed() {
        return new DatasetGraphMap(GraphFactory.createDefaultGraph());
    }

    public static interface GraphMaker {
        public Graph create();
    }
}

