/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;
import org.apache.jena.datatypes.xsd.impl.XSDBaseNumericType;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionBase1;
import org.apache.jena.sparql.function.FunctionFactory;

public class CastXSD
implements FunctionFactory {
    protected final XSDDatatype castType;

    public CastXSD(XSDDatatype dt) {
        this.castType = dt;
    }

    @Override
    public Function create(String uri) {
        return new Instance(this.castType);
    }

    protected static class Instance
    extends FunctionBase1 {
        XSDDatatype castType;
        static boolean whitespaceSurroundAllowed = false;

        Instance(XSDDatatype dt) {
            this.castType = dt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public NodeValue exec(NodeValue v) {
            String s = null;
            Node n = v.asNode();
            if (n.isBlank()) {
                throw new ExprEvalException("CastXSD: Can't cast blank nodes: " + v);
            }
            if (n.isURI()) {
                if (!this.castType.equals(XSDDatatype.XSDstring)) throw new ExprEvalException("CastXSD: Can't cast node: " + v + " to " + this.castType.getURI());
                s = n.getURI();
            } else {
                if (!n.isLiteral()) throw new ExprEvalException("CastXSD: Can't cast node: " + v + "(not a literal, not URI to string)");
                s = n.getLiteralLexicalForm();
            }
            if (s == null && v.isString()) {
                s = v.getString();
            }
            if (s != null) return this.cast(s, v, this.castType);
            throw new ExprEvalException("CastXSD: Can't cast: " + v + "(has no string appearance)");
        }

        protected NodeValue cast(String s, NodeValue nv, XSDDatatype castType2) {
            if (whitespaceSurroundAllowed) {
                s = s.trim();
            } else if ((this.castType instanceof XSDBaseNumericType || this.castType.equals(XSDDatatype.XSDfloat) || this.castType.equals(XSDDatatype.XSDdouble) || this.castType.equals(XSDDatatype.XSDboolean) || this.castType instanceof XSDAbstractDateTimeType) && (s.startsWith(" ") || s.endsWith(" "))) {
                throw new ExprEvalException("CastXSD: Not a valid literal form (has whitespace): '" + s + "'");
            }
            try {
                if (!this.castType.isValid(s)) {
                    throw new ExprEvalException("CastXSD: Not a valid literal form: '" + s + "'");
                }
                return NodeValue.makeNode(s, (RDFDatatype)this.castType);
            }
            catch (RuntimeException ex) {
                throw new ExprEvalException("CastXSD: Not a strictly valid literal form: '" + s + "'");
            }
        }
    }
}

