/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.CastXSD;
import org.apache.jena.sparql.function.Function;

public class CastXSD_Boolean
extends CastXSD {
    public CastXSD_Boolean(XSDDatatype dt) {
        super(dt);
    }

    @Override
    public Function create(String uri) {
        return new Instance(this.castType);
    }

    protected static class Instance
    extends CastXSD.Instance {
        Instance(XSDDatatype dt) {
            super(dt);
        }

        @Override
        protected NodeValue cast(String s, NodeValue nv, XSDDatatype castType) {
            if (nv.isNumber()) {
                if (nv.isFloat() || nv.isDouble()) {
                    double d;
                    double d2 = d = nv.isDouble() ? nv.getDouble() : (double)nv.getFloat();
                    if (d == 0.0 || Double.isNaN(d)) {
                        return NodeValue.FALSE;
                    }
                    return NodeValue.TRUE;
                }
                if (nv.isDecimal()) {
                    if (nv.getDecimal().compareTo(BigDecimal.ZERO) == 0) {
                        return NodeValue.FALSE;
                    }
                    return NodeValue.TRUE;
                }
                if (nv.isInteger()) {
                    if (nv.getInteger().compareTo(BigInteger.ZERO) == 0) {
                        return NodeValue.FALSE;
                    }
                    return NodeValue.TRUE;
                }
            }
            if (nv.isBoolean()) {
                return nv;
            }
            return super.cast(s, nv, castType);
        }
    }
}

