/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.ArrayList;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.AllCapabilities;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSPARQL
extends GraphBase
implements Graph {
    private static Logger log = LoggerFactory.getLogger(GraphSPARQL.class);
    private DatasetGraph dataset;
    private QueryEngineFactory factory;

    public GraphSPARQL(DatasetGraph dataset, QueryEngineFactory factory) {
        this.dataset = dataset;
        this.factory = factory;
    }

    public GraphSPARQL(DatasetGraph dataset, String uri) {
        this(dataset, NodeFactory.createURI((String)uri));
    }

    public GraphSPARQL(DatasetGraph dsg, Node gn) {
        this.dataset = DatasetGraphFactory.create(dsg);
        this.dataset.setDefaultGraph(dsg.getGraph(gn));
        this.factory = null;
    }

    public GraphSPARQL(Graph graph) {
        this(graph, null);
    }

    public GraphSPARQL(Graph graph, QueryEngineFactory factory) {
        this.dataset = DatasetGraphFactory.createOneGraph(graph);
        this.factory = factory;
    }

    private DatasetGraph toDSG(DatasetGraph dataset, Node graphNode) {
        Graph graph = graphNode == null ? dataset.getDefaultGraph() : dataset.getGraph(graphNode);
        DatasetGraph dsGraph = DatasetGraphFactory.create(graph);
        return dsGraph;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities(){

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        Object s = m.getMatchSubject();
        Var sVar = null;
        if (s == null) {
            sVar = Var.alloc("s");
            s = sVar;
        }
        Object p = m.getMatchPredicate();
        Var pVar = null;
        if (p == null) {
            pVar = Var.alloc("p");
            p = pVar;
        }
        Object o = m.getMatchObject();
        Var oVar = null;
        if (o == null) {
            oVar = Var.alloc("o");
            o = oVar;
        }
        Triple triple = new Triple(s, p, o);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        OpBGP op = new OpBGP(pattern);
        Plan plan = this.factory.create(op, this.getDataset(), BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        while (qIter.hasNext()) {
            Binding b = qIter.nextBinding();
            Object sResult = s;
            Object pResult = p;
            Object oResult = o;
            if (sVar != null) {
                sResult = b.get(sVar);
            }
            if (pVar != null) {
                pResult = b.get(pVar);
            }
            if (oVar != null) {
                oResult = b.get(oVar);
            }
            Triple resultTriple = new Triple(sResult, pResult, oResult);
            if (log.isDebugEnabled()) {
                log.debug("  " + resultTriple);
            }
            triples.add(resultTriple);
        }
        qIter.close();
        return WrappedIterator.createNoRemove(triples.iterator());
    }
}

