/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.IterLib;

public abstract class PropertyFunctionBase
implements PropertyFunction {
    PropFuncArgType subjArgType;
    PropFuncArgType objFuncArgType;

    protected PropertyFunctionBase() {
        this(PropFuncArgType.PF_ARG_EITHER, PropFuncArgType.PF_ARG_EITHER);
    }

    protected PropertyFunctionBase(PropFuncArgType subjArgType, PropFuncArgType objFuncArgType) {
        this.subjArgType = subjArgType;
        this.objFuncArgType = objFuncArgType;
    }

    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (this.subjArgType.equals(PropFuncArgType.PF_ARG_SINGLE) && argSubject.isList()) {
            throw new QueryBuildException("List arguments (subject) to " + predicate.getURI());
        }
        if (this.subjArgType.equals(PropFuncArgType.PF_ARG_LIST) && !argSubject.isList()) {
            throw new QueryBuildException("Single argument, list expected (subject) to " + predicate.getURI());
        }
        if (this.objFuncArgType.equals(PropFuncArgType.PF_ARG_SINGLE) && argObject.isList() && !argObject.isNode()) {
            throw new QueryBuildException("List arguments (object) to " + predicate.getURI());
        }
        if (this.objFuncArgType.equals(PropFuncArgType.PF_ARG_LIST) && !argObject.isList()) {
            throw new QueryBuildException("Single argument, list expected (object) to " + predicate.getURI());
        }
    }

    @Override
    public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        return new RepeatApplyIteratorPF(input, argSubject, predicate, argObject, execCxt);
    }

    public abstract QueryIterator exec(Binding var1, PropFuncArg var2, Node var3, PropFuncArg var4, ExecutionContext var5);

    class RepeatApplyIteratorPF
    extends QueryIterRepeatApply {
        private ExecutionContext execCxt;
        private PropFuncArg argSubject;
        private Node predicate;
        private PropFuncArg argObject;

        public RepeatApplyIteratorPF(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
            super(input, execCxt);
            this.argSubject = argSubject;
            this.predicate = predicate;
            this.argObject = argObject;
        }

        @Override
        protected QueryIterator nextStage(Binding binding) {
            QueryIterator iter = PropertyFunctionBase.this.exec(binding, this.argSubject, this.predicate, this.argObject, super.getExecContext());
            if (iter == null) {
                iter = IterLib.noResults(this.execCxt);
            }
            return iter;
        }

        @Override
        protected void details(IndentedWriter out, SerializationContext sCxt) {
            out.print("PropertyFunction [" + FmtUtils.stringForNode(this.predicate, sCxt) + "]");
            out.print("[");
            this.argSubject.output(out, sCxt);
            out.print("][");
            this.argObject.output(out, sCxt);
            out.print("]");
            out.println();
        }
    }
}

