/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;

public class strSplit
extends PFuncSimpleAndList {
    @Override
    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        if (!Var.isVar(subject)) {
            throw new ExprEvalException("Subject is not a variable (" + subject + ")");
        }
        if (object.getArgListSize() != 2) {
            throw new ExprEvalException("Object list must contain exactly two arguments, the string to split and a regular expression");
        }
        String s = object.getArg(0).getLiteralLexicalForm();
        String regex = object.getArg(1).getLiteralLexicalForm();
        Var subjectVar = Var.alloc(subject);
        String[] tokens2 = StrUtils.split((String)s, (String)regex);
        Iterator it = Iter.map(Arrays.asList(tokens2).iterator(), item -> BindingFactory.binding(binding, subjectVar, NodeFactory.createLiteral((String)item)));
        return new QueryIterPlainWrapper(it, execCxt);
    }
}

