/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;

public class VarUtils {
    public static Set<Var> getVars(Triple triple) {
        HashSet<Var> x = new HashSet<Var>();
        VarUtils.addVarsFromTriple(x, triple);
        return x;
    }

    public static void addVarsFromTriple(Collection<Var> acc, Triple t) {
        VarUtils.addVar(acc, t.getSubject());
        VarUtils.addVar(acc, t.getPredicate());
        VarUtils.addVar(acc, t.getObject());
    }

    public static void addVarsFromTriplePath(Collection<Var> acc, TriplePath tpath) {
        VarUtils.addVar(acc, tpath.getSubject());
        VarUtils.addVar(acc, tpath.getObject());
    }

    public static void addVar(Collection<Var> acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(Var.alloc(n));
        }
    }

    public static void addVars(Collection<Var> acc, BasicPattern pattern) {
        VarUtils.addVars(acc, pattern.getList());
    }

    public static void addVars(Collection<Var> acc, Collection<Triple> triples) {
        for (Triple triple : triples) {
            VarUtils.addVarsFromTriple(acc, triple);
        }
    }
}

