/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.aggregate.AggAvg;
import org.apache.jena.sparql.expr.aggregate.AggAvgDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.AggCountDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCountVar;
import org.apache.jena.sparql.expr.aggregate.AggCountVarDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCustom;
import org.apache.jena.sparql.expr.aggregate.AggGroupConcat;
import org.apache.jena.sparql.expr.aggregate.AggGroupConcatDistinct;
import org.apache.jena.sparql.expr.aggregate.AggMax;
import org.apache.jena.sparql.expr.aggregate.AggMaxDistinct;
import org.apache.jena.sparql.expr.aggregate.AggMin;
import org.apache.jena.sparql.expr.aggregate.AggMinDistinct;
import org.apache.jena.sparql.expr.aggregate.AggNull;
import org.apache.jena.sparql.expr.aggregate.AggSample;
import org.apache.jena.sparql.expr.aggregate.AggSampleDistinct;
import org.apache.jena.sparql.expr.aggregate.AggSum;
import org.apache.jena.sparql.expr.aggregate.AggSumDistinct;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.expr.aggregate.Aggregator;

public class AggregatorFactory {
    public static Aggregator createCount(boolean distinct) {
        return distinct ? new AggCountDistinct() : new AggCount();
    }

    public static Aggregator createCountExpr(boolean distinct, Expr expr) {
        return distinct ? new AggCountVarDistinct(expr) : new AggCountVar(expr);
    }

    public static Aggregator createSum(boolean distinct, Expr expr) {
        return distinct ? new AggSumDistinct(expr) : new AggSum(expr);
    }

    public static Aggregator createMin(boolean distinct, Expr expr) {
        return distinct ? new AggMinDistinct(expr) : new AggMin(expr);
    }

    public static Aggregator createMax(boolean distinct, Expr expr) {
        return distinct ? new AggMaxDistinct(expr) : new AggMax(expr);
    }

    public static Aggregator createAvg(boolean distinct, Expr expr) {
        return distinct ? new AggAvgDistinct(expr) : new AggAvg(expr);
    }

    public static Aggregator createSample(boolean distinct, Expr expr) {
        return distinct ? new AggSampleDistinct(expr) : new AggSample(expr);
    }

    public static Aggregator createGroupConcat(boolean distinct, Expr expr, String separator, ExprList orderedBy) {
        if (orderedBy != null && !orderedBy.isEmpty()) {
            throw new NotImplemented("GROUP_CONCAT / ORDER BY not implemented yet");
        }
        return distinct ? new AggGroupConcatDistinct(expr, separator) : new AggGroupConcat(expr, separator);
    }

    public static Aggregator createAggNull() {
        return new AggNull();
    }

    public static Aggregator createCustom(boolean usedAsFunction, boolean distinct, String iri2, ExprList a) {
        if (!AggregateRegistry.isRegistered(iri2)) {
            Log.warn(AggregatorFactory.class, (String)("Not registered: custom aggregate <" + iri2 + ">"));
        }
        return new AggCustom(iri2, a);
    }
}

