/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpSlice
extends OpModifier {
    private long start;
    private long length;

    public OpSlice(Op subOp, long start, long length) {
        super(subOp);
        this.start = start;
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    public long getStart() {
        return this.start;
    }

    public Op copy() {
        return null;
    }

    @Override
    public String getName() {
        return "slice";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        return new OpSlice(subOp, this.start, this.length);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        return this.getSubOp().hashCode() ^ (int)(this.start & 0xFFFFFFFFFFFFFFFFL) ^ (int)(this.length & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpSlice)) {
            return false;
        }
        OpSlice opSlice = (OpSlice)other;
        if (opSlice.start != this.start || opSlice.length != this.length) {
            return false;
        }
        return this.getSubOp().equalTo(opSlice.getSubOp(), labelMap);
    }
}

