/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetChanges;
import org.apache.jena.sparql.core.QuadAction;

public class DatasetChangesCounter
implements DatasetChanges {
    long countStart = 0L;
    long countFinish = 0L;
    long countAdd = 0L;
    long countDelete = 0L;
    long countNoAdd = 0L;
    long countNoDelete = 0L;

    @Override
    public void start() {
        ++this.countStart;
    }

    @Override
    public void change(QuadAction qaction, Node g, Node s, Node p, Node o) {
        if (qaction == null) {
            throw new NullPointerException();
        }
        switch (qaction) {
            case ADD: {
                ++this.countAdd;
                break;
            }
            case DELETE: {
                ++this.countDelete;
                break;
            }
            case NO_ADD: {
                ++this.countNoAdd;
                break;
            }
            case NO_DELETE: {
                ++this.countNoDelete;
            }
        }
    }

    @Override
    public void finish() {
        ++this.countFinish;
    }

    public boolean hasChanged() {
        return this.countAdd > 0L || this.countDelete > 0L;
    }

    @Override
    public void reset() {
        this.countStart = 0L;
        this.countFinish = 0L;
        this.countAdd = 0L;
        this.countDelete = 0L;
        this.countNoAdd = 0L;
        this.countNoDelete = 0L;
    }
}

