/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.iterator.ExtendedIterator;

public class DatasetGraphMap
extends DatasetGraphTriplesQuads {
    private final DatasetGraphFactory.GraphMaker graphMaker;
    private final Map<Node, Graph> graphs = new HashMap<Node, Graph>();
    private Graph defaultGraph;
    private final Transactional txn = TransactionalLock.createMRSW();

    public DatasetGraphMap() {
        this(DatasetGraphFactory.memGraphMaker);
    }

    public DatasetGraphMap(DatasetGraphFactory.GraphMaker graphMaker) {
        this(graphMaker.create(), graphMaker);
    }

    public DatasetGraphMap(Graph defaultGraph, DatasetGraphFactory.GraphMaker graphMaker) {
        this.defaultGraph = defaultGraph;
        this.graphMaker = graphMaker;
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public void commit() {
        this.txn.commit();
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphs.keySet().iterator();
    }

    @Override
    protected void addToDftGraph(Node s, Node p, Node o) {
        this.getDefaultGraph().add(Triple.create((Node)s, (Node)p, (Node)o));
    }

    @Override
    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.getGraph(g).add(Triple.create((Node)s, (Node)p, (Node)o));
    }

    @Override
    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.getDefaultGraph().delete(Triple.create((Node)s, (Node)p, (Node)o));
    }

    @Override
    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.getGraph(g).delete(Triple.create((Node)s, (Node)p, (Node)o));
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        ExtendedIterator iter = this.getDefaultGraph().find(s, p, o);
        return GraphUtils.triples2quadsDftGraph((Iterator<Triple>)iter);
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        ExtendedIterator iter = this.getGraph(g).find(s, p, o);
        return GraphUtils.triples2quads(g, (Iterator<Triple>)iter);
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        Iterator<Node> gnames = this.listGraphNodes();
        IteratorConcat iter = new IteratorConcat();
        while (gnames.hasNext()) {
            Node gn = gnames.next();
            Iterator<Quad> qIter = this.findInSpecificNamedGraph(gn, s, p, o);
            if (qIter == null) continue;
            iter.add(qIter);
        }
        return iter;
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Graph g = this.graphs.get(graphNode);
        if (g == null && (g = this.getGraphCreate()) != null) {
            this.graphs.put(graphNode, g);
        }
        return g;
    }

    protected Graph getGraphCreate() {
        Graph g = this.graphMaker.create();
        if (g == null) {
            throw new ARQException("Can't make new graphs");
        }
        return g;
    }

    @Override
    public long size() {
        return this.graphs.size();
    }
}

