/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetGraphOne
extends DatasetGraphBaseFind {
    private final Graph graph;
    private final Transactional txn = TransactionalLock.createMRSW();

    public DatasetGraphOne(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public void commit() {
        this.txn.commit();
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return DatasetGraphOne.isDefaultGraph(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.graph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (DatasetGraphOne.isDefaultGraph(graphNode)) {
            return this.graph;
        }
        return null;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return new NullIterator();
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        if (!Quad.isDefaultGraph(g)) {
            throw new UnsupportedOperationException("DatasetGraphOne.add/named graph");
        }
        this.graph.add(new Triple(s, p, o));
    }

    @Override
    public void add(Quad quad) {
        if (!DatasetGraphOne.isDefaultGraph(quad)) {
            throw new UnsupportedOperationException("DatasetGraphOne.add/named graph");
        }
        this.graph.add(quad.asTriple());
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        if (!Quad.isDefaultGraph(g)) {
            throw new UnsupportedOperationException("DatasetGraphOne.delete/named graph");
        }
        this.graph.delete(new Triple(s, p, o));
    }

    @Override
    public void delete(Quad quad) {
        if (!DatasetGraphOne.isDefaultGraph(quad)) {
            throw new UnsupportedOperationException("DatasetGraphOne.delete/named graph");
        }
        this.graph.delete(quad.asTriple());
    }

    @Override
    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("DatasetGraphOne.setDefaultGraph");
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        throw new UnsupportedOperationException("DatasetGraphOne.addGraph");
    }

    @Override
    public void removeGraph(Node graphName) {
        throw new UnsupportedOperationException("DatasetGraphOne.removeGraph");
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return GraphUtils.triples2quadsDftGraph((Iterator<Triple>)this.graph.find(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return Iter.nullIterator();
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return Iter.nullIterator();
    }

    protected static boolean isDefaultGraph(Quad quad) {
        return DatasetGraphOne.isDefaultGraph(quad.getGraph());
    }

    protected static boolean isDefaultGraph(Node quadGraphNode) {
        return quadGraphNode == null || Quad.isDefaultGraph(quadGraphNode);
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        if (DatasetGraphOne.isWildcard(g) || DatasetGraphOne.isDefaultGraph(g)) {
            return GraphUtils.triples2quadsDftGraph((Iterator<Triple>)this.graph.find(s, p, o));
        }
        return new NullIterator();
    }

    @Override
    public void close() {
        this.graph.close();
        super.close();
    }
}

