/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.ArrayList;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.sparql.vocabulary.ResultSetGraphVocab;
import org.apache.jena.vocabulary.RDF;

public class RDFInput
extends ResultSetMem {
    public RDFInput(Model model) {
        this.buildFromDumpFormat(model);
    }

    private void buildFromDumpFormat(Model resultsModel) {
        this.varNames = new ArrayList();
        StmtIterator sIter = resultsModel.listStatements(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            Resource root2 = s.getSubject();
            this.buildOneResource(root2);
        }
        sIter.close();
        this.reset();
    }

    private void buildOneResource(Resource root2) {
        this.buildVariables(root2);
        int count = this.buildPreprocess(root2);
        if (root2.getModel().contains(null, ResultSetGraphVocab.index, (RDFNode)null)) {
            this.buildRowsOrdered(root2, count);
        } else {
            this.buildRows(root2);
        }
    }

    private void buildVariables(Resource root2) {
        StmtIterator rVarsIter = root2.listProperties(ResultSetGraphVocab.resultVariable);
        while (rVarsIter.hasNext()) {
            String varName = rVarsIter.nextStatement().getString();
            this.varNames.add(varName);
        }
        rVarsIter.close();
    }

    private int buildPreprocess(Resource root2) {
        StmtIterator solnIter = root2.listProperties(ResultSetGraphVocab.solution);
        int rows = 0;
        int indexed = 0;
        while (solnIter.hasNext()) {
            Resource soln = solnIter.nextStatement().getResource();
            ++rows;
            if (!soln.hasProperty(ResultSetGraphVocab.index)) continue;
            ++indexed;
        }
        solnIter.close();
        if (indexed > 0 && rows != indexed) {
            Log.warn((Object)this, (String)("Rows = " + rows + " but only " + indexed + " indexes"));
            return rows;
        }
        return rows;
    }

    private void buildRowsOrdered(Resource root2, int count) {
        Literal ind;
        StmtIterator sIter;
        Model m = root2.getModel();
        int index = 1;
        while ((sIter = m.listStatements(null, ResultSetGraphVocab.index, (RDFNode)(ind = m.createTypedLiteral(index)))).hasNext()) {
            Statement s = sIter.nextStatement();
            if (sIter.hasNext()) {
                Log.warn((Object)this, (String)("More than one solution: index = " + index));
            }
            Resource soln = s.getSubject();
            Binding rb = this.buildBinding(soln);
            this.rows.add(rb);
            sIter.close();
            ++index;
        }
        if (this.rows.size() != count) {
            Log.warn((Object)this, (String)("Found " + this.rows.size() + ": expected " + count));
        }
    }

    private void buildRows(Resource root2) {
        int count = 0;
        StmtIterator solnIter = root2.listProperties(ResultSetGraphVocab.solution);
        while (solnIter.hasNext()) {
            Resource soln = solnIter.nextStatement().getResource();
            ++count;
            Binding rb = this.buildBinding(soln);
            this.rows.add(rb);
        }
        solnIter.close();
        if (root2.hasProperty(ResultSetGraphVocab.size)) {
            try {
                int size = root2.getRequiredProperty(ResultSetGraphVocab.size).getInt();
                if (size != count) {
                    Log.warn((Object)this, (String)("Warning: Declared size = " + size + " : Count = " + count));
                }
            }
            catch (JenaException jenaException) {
                // empty catch block
            }
        }
    }

    private Binding buildBinding(Resource soln) {
        BindingMap rb = BindingFactory.create();
        StmtIterator bindingIter = soln.listProperties(ResultSetGraphVocab.binding);
        while (bindingIter.hasNext()) {
            Resource binding = bindingIter.nextStatement().getResource();
            String var = binding.getRequiredProperty(ResultSetGraphVocab.variable).getString();
            try {
                RDFNode val = binding.getRequiredProperty(ResultSetGraphVocab.value).getObject();
                rb.add(Var.alloc(var), val.asNode());
            }
            catch (PropertyNotFoundException ex) {
                Log.warn((Object)this, (String)("Failed to get value for ?" + var));
            }
        }
        bindingIter.close();
        return rb;
    }

    public static ResultSet fromRDF(Model model) {
        return new RDFInput(model);
    }
}

