/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.VarAlloc;

public class LabelToNodeMap {
    Map<String, Node> bNodeLabels = new HashMap<String, Node>();
    boolean generateVars = false;
    VarAlloc allocator = null;

    public static LabelToNodeMap createBNodeMap() {
        return new LabelToNodeMap(false, null);
    }

    public static LabelToNodeMap createVarMap() {
        return new LabelToNodeMap(true, new VarAlloc("?"));
    }

    private LabelToNodeMap(boolean genVars, VarAlloc allocator) {
        this.generateVars = genVars;
        this.allocator = allocator;
    }

    public Set<String> getLabels() {
        return this.bNodeLabels.keySet();
    }

    public Node asNode(String label) {
        Node n = this.bNodeLabels.get(label);
        if (n != null) {
            return n;
        }
        n = this.allocNode();
        this.bNodeLabels.put(label, n);
        return n;
    }

    public Node allocNode() {
        if (this.generateVars) {
            return this.allocAnonVariable();
        }
        return NodeFactory.createBlankNode();
    }

    private Node allocAnonVariable() {
        return this.allocator.allocVar();
    }

    public void clear() {
        this.bNodeLabels.clear();
    }
}

