/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.graph;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.util.graph.Findable;

class FindableBasicPattern
implements Findable {
    private BasicPattern triples;

    FindableBasicPattern(BasicPattern triples) {
        this.triples = triples;
    }

    @Override
    public Iterator<Triple> find(Node s, Node p, Node o) {
        if (s == Node.ANY) {
            s = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        ArrayList<Triple> r = new ArrayList<Triple>();
        for (Triple t : this.triples) {
            if (s != null && !t.getSubject().equals((Object)s) || p != null && !t.getPredicate().equals((Object)p) || o != null && !t.getObject().equals((Object)o)) continue;
            r.add(t);
        }
        return r.iterator();
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        if (s == Node.ANY) {
            s = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        for (Triple t : this.triples) {
            if (s != null && !t.getSubject().equals((Object)s) || p != null && !t.getPredicate().equals((Object)p) || o != null && !t.getObject().equals((Object)o)) continue;
            return true;
        }
        return false;
    }
}

