/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.util.Context;

public abstract class AdapterRDFWriter
extends WriterGraphRIOTBase {
    protected abstract RDFWriter create();

    @Override
    public abstract Lang getLang();

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        RDFWriter w = this.create();
        AdapterRDFWriter.setProperties(w, context);
        w.write(ModelFactory.createModelForGraph((Graph)graph), out, baseURI);
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        RDFWriter w = this.create();
        AdapterRDFWriter.setProperties(w, context);
        w.write(ModelFactory.createModelForGraph((Graph)graph), out, baseURI);
    }

    private static void setProperties(RDFWriter w, Context context) {
        try {
            Map p = (Map)context.get(SysRIOT.rdfWriterProperties);
            if (p != null) {
                p.forEach((k, v) -> w.setProperty(k, v));
            }
        }
        catch (Throwable ex) {
            Log.warn(AdapterRDFWriter.class, (String)"Problem setting properties", (Throwable)ex);
        }
    }
}

