/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.atlas.lib.DS;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinctReduced;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpExtendAssign;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.VarUtils;

public class TransformFilterPlacement
extends TransformCopy {
    static final ExprList emptyList = ExprList.emptyList;
    static final Placement noChangePlacement = null;
    private final boolean includeBGPs;
    static boolean pushRightAsWellAsLeft = true;

    private static Placement result(Op op, ExprList remaining) {
        if (op == null) {
            return noChangePlacement;
        }
        return new Placement(op, remaining);
    }

    private Placement resultNoChange(Op original) {
        return noChangePlacement;
    }

    private boolean isNoChange(Placement placement) {
        return !this.isChange(placement);
    }

    private boolean isChange(Placement placement) {
        return placement != noChangePlacement;
    }

    public static Op transform(ExprList exprs, BasicPattern bgp) {
        Op op;
        Placement placement = TransformFilterPlacement.placeBGP(exprs, bgp);
        Op op2 = op = placement == null ? new OpBGP(bgp) : placement.op;
        if (placement != null) {
            op = TransformFilterPlacement.buildFilter(placement.unplaced, op);
        }
        return op;
    }

    public static Op transform(ExprList exprs, Node graphNode, BasicPattern bgp) {
        Op op;
        Placement placement = TransformFilterPlacement.placeQuadPattern(exprs, graphNode, bgp);
        Op op2 = op = placement == null ? new OpQuadPattern(graphNode, bgp) : placement.op;
        if (placement != null) {
            op = TransformFilterPlacement.buildFilter(placement.unplaced, op);
        }
        return op;
    }

    public TransformFilterPlacement() {
        this(true);
    }

    public TransformFilterPlacement(boolean includeBGPs) {
        this.includeBGPs = includeBGPs;
    }

    public static Placement filterPlacement$(ExprList exprs, Op op) {
        TransformFilterPlacement t = new TransformFilterPlacement();
        return t.transform(exprs, op);
    }

    @Override
    public Op transform(OpFilter opFilter, Op x) {
        Placement placement;
        ExprList exprs = opFilter.getExprs();
        ExprList exprs2 = null;
        for (Object expr : exprs) {
            if (ExprLib.isStable((Expr)expr)) continue;
            if (exprs2 == null) {
                exprs2 = new ExprList();
            }
            exprs2.add((Expr)expr);
        }
        if (exprs2 != null) {
            ExprList exprs1 = new ExprList();
            for (Expr expr : exprs) {
                if (!ExprLib.isStable(expr)) continue;
                exprs1.add(expr);
            }
            exprs = exprs1;
        }
        if (this.isNoChange(placement = this.transform(exprs, x))) {
            return super.transform(opFilter, x);
        }
        Op op = TransformFilterPlacement.buildFilter(placement);
        if (exprs2 != null) {
            op = OpFilter.filterBy(exprs2, op);
        }
        return op;
    }

    private Op transformOpAlways(ExprList exprs, Op x) {
        Placement placement = this.transform(exprs, x);
        if (this.isNoChange(placement)) {
            return TransformFilterPlacement.buildFilter(exprs, x);
        }
        return TransformFilterPlacement.buildFilter(placement);
    }

    private Placement transform(ExprList exprs, Op input) {
        Placement placement = noChangePlacement;
        if (input instanceof OpBGP) {
            placement = this.placeOrWrapBGP(exprs, (OpBGP)input);
        } else if (input instanceof OpQuadPattern) {
            placement = this.placeOrWrapQuadPattern(exprs, (OpQuadPattern)input);
        } else if (input instanceof OpSequence) {
            placement = this.placeSequence(exprs, (OpSequence)input);
        } else if (input instanceof OpJoin) {
            placement = this.placeJoin(exprs, (OpJoin)input);
        } else if (input instanceof OpConditional) {
            placement = this.placeConditional(exprs, (OpConditional)input);
        } else if (input instanceof OpDisjunction) {
            placement = this.placeDisjunction(exprs, (OpDisjunction)input);
        } else if (input instanceof OpLeftJoin) {
            placement = this.placeLeftJoin(exprs, (OpLeftJoin)input);
        } else if (input instanceof OpFilter) {
            placement = this.placeFilter(exprs, (OpFilter)input);
        } else if (input instanceof OpUnion) {
            placement = this.placeUnion(exprs, (OpUnion)input);
        } else if (input instanceof OpPropFunc) {
            placement = this.placePropertyFunction(exprs, (OpPropFunc)input);
        } else if (input instanceof OpProcedure) {
            placement = this.placeProcedure(exprs, (OpProcedure)input);
        } else if (input instanceof OpExtend) {
            placement = this.placeExtend(exprs, (OpExtend)input);
        } else if (input instanceof OpAssign) {
            placement = this.placeAssign(exprs, (OpAssign)input);
        } else if (input instanceof OpProject) {
            placement = this.placeProject(exprs, (OpProject)input);
        } else if (input instanceof OpDistinctReduced) {
            placement = this.placeDistinctReduced(exprs, (OpDistinctReduced)input);
        } else if (input instanceof OpTable) {
            placement = this.placeTable(exprs, (OpTable)input);
        }
        return placement;
    }

    private Placement placeFilter(ExprList exprs, OpFilter input) {
        Op op = input.getSubOp();
        ExprList exprsInner = input.getExprs();
        ExprList exprsOuter = exprs;
        Placement p = this.transform(exprsOuter, input.getSubOp());
        if (this.isChange(p)) {
            op = p.op;
            exprsOuter = p.unplaced;
        }
        Op f = OpFilter.filterBy(exprsInner, op);
        return new Placement(f, exprsOuter);
    }

    private Placement placeOrWrapBGP(ExprList exprs, OpBGP x) {
        return this.placeOrWrapBGP(exprs, x.getPattern());
    }

    private Placement placeOrWrapBGP(ExprList exprsIn, BasicPattern pattern) {
        if (this.includeBGPs) {
            return TransformFilterPlacement.placeBGP(exprsIn, pattern);
        }
        return this.wrapBGP(exprsIn, pattern);
    }

    private static Placement placeBGP(ExprList exprsIn, BasicPattern pattern) {
        ExprList exprs = ExprList.copy(exprsIn);
        Set patternVarsScope = DS.set();
        Op op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, null);
        for (Triple triple : pattern) {
            OpBGP opBGP = TransformFilterPlacement.getBGP(op);
            if (opBGP == null) {
                opBGP = new OpBGP();
                op = OpSequence.create(op, opBGP);
            }
            opBGP.getPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, op);
        }
        return TransformFilterPlacement.result(op, exprs);
    }

    private Placement wrapBGP(ExprList exprsIn, BasicPattern pattern) {
        Set vs = DS.set();
        VarUtils.addVars((Collection<Var>)vs, pattern);
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr e2 : exprsIn) {
            Set<Var> eVars = e2.getVarsMentioned();
            if (vs.containsAll(eVars)) {
                pushed.add(e2);
                continue;
            }
            unpushed.add(e2);
        }
        if (pushed.size() == 0) {
            return noChangePlacement;
        }
        Op opx = OpFilter.filterBy(pushed, new OpBGP(pattern));
        return TransformFilterPlacement.result(opx, unpushed);
    }

    private static OpBGP getBGP(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpBGP) {
            return (OpBGP)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpBGP) {
            return (OpBGP)opTop;
        }
        return null;
    }

    private Placement placeOrWrapQuadPattern(ExprList exprs, OpQuadPattern pattern) {
        return this.placeOrWrapQuadPattern(exprs, pattern.getGraphNode(), pattern.getBasicPattern());
    }

    private Placement placeOrWrapQuadPattern(ExprList exprsIn, Node graphNode, BasicPattern pattern) {
        if (this.includeBGPs) {
            return TransformFilterPlacement.placeQuadPattern(exprsIn, graphNode, pattern);
        }
        return TransformFilterPlacement.wrapQuadPattern(exprsIn, graphNode, pattern);
    }

    private static Placement placeQuadPattern(ExprList exprsIn, Node graphNode, BasicPattern pattern) {
        ExprList exprs = ExprList.copy(exprsIn);
        Set patternVarsScope = DS.set();
        Op op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, null);
        if (Var.isVar(graphNode)) {
            VarUtils.addVar(patternVarsScope, (Node)Var.alloc(graphNode));
        }
        for (Triple triple : pattern) {
            OpQuadPattern opQuad = TransformFilterPlacement.getQuads(op);
            if (opQuad == null) {
                opQuad = new OpQuadPattern(graphNode, new BasicPattern());
                op = OpSequence.create(op, opQuad);
            }
            opQuad.getBasicPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            op = TransformFilterPlacement.insertAnyFilter$(exprs, patternVarsScope, op);
        }
        return TransformFilterPlacement.result(op, exprs);
    }

    private static Placement wrapQuadPattern(ExprList exprsIn, Node graphNode, BasicPattern pattern) {
        Set vs = DS.set();
        VarUtils.addVars((Collection<Var>)vs, pattern);
        if (Var.isVar(graphNode)) {
            vs.add(Var.alloc(graphNode));
        }
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr e2 : exprsIn) {
            Set<Var> eVars = e2.getVarsMentioned();
            if (vs.containsAll(eVars)) {
                pushed.add(e2);
                continue;
            }
            unpushed.add(e2);
        }
        if (pushed.size() == 0) {
            return null;
        }
        return new Placement(OpFilter.filterBy(pushed, new OpQuadPattern(graphNode, pattern)), unpushed);
    }

    private static OpQuadPattern getQuads(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpQuadPattern) {
            return (OpQuadPattern)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpQuadPattern) {
            return (OpQuadPattern)opTop;
        }
        return null;
    }

    private Placement placePropertyFunction(ExprList exprsIn, OpPropFunc input) {
        Set argVars = DS.set();
        PropFuncArg.addVars(argVars, input.getSubjectArgs());
        PropFuncArg.addVars(argVars, input.getObjectArgs());
        return this.placePropertyFunctionProcedure(exprsIn, argVars, input);
    }

    private Placement placeProcedure(ExprList exprsIn, OpProcedure input) {
        Set argVars = DS.set();
        input.getArgs().varsMentioned(argVars);
        return this.placePropertyFunctionProcedure(exprsIn, argVars, input);
    }

    private Placement placePropertyFunctionProcedure(ExprList exprsIn, Set<Var> varScope, Op1 op) {
        ExprList exprListPlaceable = new ExprList();
        ExprList exprListRetain = new ExprList();
        for (Expr expr : exprsIn) {
            Set<Var> mentioned = expr.getVarsMentioned();
            if (SetUtils.disjoint(varScope, mentioned)) {
                exprListPlaceable.add(expr);
                continue;
            }
            exprListRetain.add(expr);
        }
        if (!exprListPlaceable.isEmpty()) {
            Placement p = this.transform(exprListPlaceable, op.getSubOp());
            if (this.isNoChange(p)) {
                return this.resultNoChange(op);
            }
            Op1 newOp = op.copy(p.op);
            p.unplaced.addAll(exprListRetain);
            return TransformFilterPlacement.result(newOp, p.unplaced);
        }
        return this.resultNoChange(op);
    }

    private Placement placeSequence(ExprList exprsIn, OpSequence opSequence) {
        ExprList exprs = ExprList.copy(exprsIn);
        Set varScope = DS.set();
        List<Op> ops = opSequence.getElements();
        Op op = null;
        for (Op op1 : ops) {
            op = TransformFilterPlacement.insertAnyFilter$(exprs, varScope, op);
            Op seqElt = op1;
            Placement p = this.transform(exprs, seqElt);
            if (this.isChange(p)) {
                exprs = p.unplaced;
                seqElt = p.op;
            }
            varScope.addAll(this.fixedVars(seqElt));
            op = OpSequence.create(op, seqElt);
        }
        return TransformFilterPlacement.result(op, exprs);
    }

    private Placement placeJoin(ExprList exprs, OpJoin opJoin) {
        Op left = opJoin.getLeft();
        Op right = opJoin.getRight();
        Set<Var> leftVars = this.fixedVars(left);
        Set<Var> rightVars = this.fixedVars(right);
        ExprList unpushed = new ExprList();
        ExprList pushLeft = new ExprList();
        ExprList pushRight = new ExprList();
        for (Expr expr : exprs) {
            Set<Var> vars = expr.getVarsMentioned();
            boolean pushed = false;
            if (leftVars.containsAll(vars)) {
                pushLeft.add(expr);
                pushed = true;
            }
            if (pushed && !pushRightAsWellAsLeft) continue;
            if (rightVars.containsAll(vars)) {
                pushRight.add(expr);
                pushed = true;
            }
            if (pushed) continue;
            unpushed.add(expr);
        }
        if (pushLeft.isEmpty() && pushRight.isEmpty()) {
            return null;
        }
        Op opLeftNew = left;
        if (!pushLeft.isEmpty()) {
            opLeftNew = this.transformOpAlways(pushLeft, opLeftNew);
        }
        Op opRightNew = right;
        if (!pushRight.isEmpty()) {
            opRightNew = this.transformOpAlways(pushRight, opRightNew);
        }
        Op op = OpJoin.create(opLeftNew, opRightNew);
        return TransformFilterPlacement.result(op, unpushed);
    }

    private Placement placeConditional(ExprList exprs, OpConditional opConditional) {
        Op left = opConditional.getLeft();
        Op right = opConditional.getRight();
        Placement nLeft = this.transform(exprs, left);
        if (this.isNoChange(nLeft)) {
            return TransformFilterPlacement.result(opConditional, exprs);
        }
        OpConditional op = new OpConditional(nLeft.op, right);
        return TransformFilterPlacement.result(op, nLeft.unplaced);
    }

    private Placement placeLeftJoin(ExprList exprs, OpLeftJoin opLeftJoin) {
        Op left = opLeftJoin.getLeft();
        Op right = opLeftJoin.getRight();
        Placement nLeft = this.transform(exprs, left);
        if (this.isNoChange(nLeft)) {
            return TransformFilterPlacement.result(opLeftJoin, exprs);
        }
        Op op = OpLeftJoin.create(nLeft.op, right, opLeftJoin.getExprs());
        return TransformFilterPlacement.result(op, nLeft.unplaced);
    }

    private Placement placeUnion(ExprList exprs, OpUnion input) {
        Op newRight;
        Op left = input.getLeft();
        Placement pLeft = this.transform(exprs, left);
        Op right = input.getRight();
        Placement pRight = this.transform(exprs, right);
        ExprList exprs2 = null;
        for (Expr expr : exprs) {
            boolean unplacedLeft = this.isNoChange(pLeft) || pLeft.unplaced.getList().contains(expr);
            boolean unplacedRight = this.isNoChange(pRight) || pRight.unplaced.getList().contains(expr);
            boolean placed = !unplacedLeft && !unplacedRight;
            if (placed) continue;
            if (exprs2 == null) {
                exprs2 = new ExprList();
            }
            exprs2.add(expr);
        }
        Op newLeft = pLeft == null ? left : pLeft.op;
        Op op = newRight = pRight == null ? right : pRight.op;
        if (exprs2 == null) {
            exprs2 = emptyList;
        }
        Op2 op2 = input.copy(newLeft, newRight);
        return TransformFilterPlacement.result(op2, exprs2);
    }

    private Placement placeDisjunction(ExprList exprs, OpDisjunction input) {
        ArrayList<Expr> unplaced = new ArrayList<Expr>(exprs.getList());
        ArrayList<Placement> placements = new ArrayList<Placement>(exprs.size());
        Boolean someChange = Boolean.FALSE;
        for (Op op : input.getElements()) {
            Placement p = this.transform(exprs, op);
            if (this.isChange(p)) {
                unplaced.retainAll(p.unplaced.getList());
                someChange = Boolean.TRUE;
            } else {
                p = TransformFilterPlacement.result(op, exprs);
            }
            placements.add(p);
        }
        if (!someChange.booleanValue()) {
            return noChangePlacement;
        }
        ArrayList<Expr> retained = new ArrayList<Expr>(exprs.getList());
        retained.removeAll(unplaced);
        ArrayList<Op> ops = new ArrayList<Op>(input.size());
        for (Placement p : placements) {
            p.unplaced.getListRaw().removeAll(unplaced);
            ops.add(TransformFilterPlacement.buildFilter(p));
        }
        return TransformFilterPlacement.result(input.copy(ops), new ExprList(unplaced));
    }

    private Placement placeExtend(ExprList exprs, OpExtend input) {
        return this.processExtendAssign(exprs, input);
    }

    private Placement placeAssign(ExprList exprs, OpAssign input) {
        return this.processExtendAssign(exprs, input);
    }

    private Placement processExtendAssign(ExprList exprs, OpExtendAssign input) {
        List<Var> vars1 = input.getVarExprList().getVars();
        Op subOp = input.getSubOp();
        ExprList remaining = exprs;
        Placement p = this.transform(exprs, input.getSubOp());
        if (this.isChange(p)) {
            subOp = p.op;
            remaining = p.unplaced;
        }
        Set<Var> subVars = OpVars.fixedVars(subOp);
        subVars.addAll(input.getVarExprList().getVars());
        ExprList wrapping = new ExprList();
        ExprList unplaced = new ExprList();
        for (Expr expr : remaining) {
            Set<Var> exprVars = expr.getVarsMentioned();
            if (subVars.containsAll(exprVars)) {
                wrapping.add(expr);
                continue;
            }
            unplaced.add(expr);
        }
        Op result = input.copy(subOp);
        if (!wrapping.isEmpty()) {
            result = OpFilter.filterBy(wrapping, result);
        }
        return TransformFilterPlacement.result(result, unplaced);
    }

    private Placement placeProject(ExprList exprs, OpProject input) {
        List<Var> varsProject = input.getVars();
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr expr : exprs) {
            Set<Var> exprVars = expr.getVarsMentioned();
            if (varsProject.containsAll(exprVars)) {
                pushed.add(expr);
                continue;
            }
            unpushed.add(expr);
        }
        if (pushed.isEmpty()) {
            return this.resultNoChange(input);
        }
        return this.processSubOp1(pushed, unpushed, input);
    }

    private Placement processSubOp1(ExprList pushed, ExprList unpushed, Op1 input) {
        Op opSub = input.getSubOp();
        Placement subPlacement = this.transform(pushed, opSub);
        if (this.isNoChange(subPlacement)) {
            Op op1 = input.getSubOp();
            if (pushed != null && !pushed.isEmpty()) {
                op1 = OpFilter.filterBy(pushed, op1);
            }
            Op1 op2 = input.copy(op1);
            return TransformFilterPlacement.result(op2, unpushed);
        }
        Op op_a = OpFilter.filterBy(subPlacement.unplaced, subPlacement.op);
        op_a = input.copy(op_a);
        return TransformFilterPlacement.result(op_a, unpushed);
    }

    private Placement placeDistinctReduced(ExprList exprs, OpDistinctReduced input) {
        Op subOp = input.getSubOp();
        Placement p = this.transform(exprs, subOp);
        if (this.isNoChange(p)) {
            return this.resultNoChange(input);
        }
        Op op = p.op;
        op = input.copy(op);
        return TransformFilterPlacement.result(op, p.unplaced);
    }

    private Placement placeTable(ExprList exprs, OpTable input) {
        exprs = ExprList.copy(exprs);
        Op op = TransformFilterPlacement.insertAnyFilter$(exprs, input.getTable().getVars(), input);
        return TransformFilterPlacement.result(op, exprs);
    }

    private Set<Var> fixedVars(Op op) {
        return OpVars.fixedVars(op);
    }

    private static Op insertAnyFilter$(ExprList unplacedExprs, Collection<Var> patternVarsScope, Op op) {
        Iterator<Expr> iter = unplacedExprs.iterator();
        while (iter.hasNext()) {
            Expr expr = iter.next();
            Set<Var> exprVars = expr.getVarsMentioned();
            if (!patternVarsScope.containsAll(exprVars)) continue;
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }

    private static <T> boolean disjoint(Collection<T> collection, Collection<T> possibleElts) {
        return CollectionUtils.disjoint(collection, possibleElts);
    }

    private static Op buildFilter(Placement placement) {
        if (placement == null) {
            return null;
        }
        if (placement.unplaced.isEmpty()) {
            return placement.op;
        }
        return TransformFilterPlacement.buildFilter(placement.unplaced, placement.op);
    }

    private static Op buildFilter(ExprList exprs, Op op) {
        if (exprs == null || exprs.isEmpty()) {
            return op;
        }
        for (Expr expr : exprs) {
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
        }
        return op;
    }

    private /* synthetic */ void lambda$placeDisjunction$0(ExprList exprs, List x, Op op) {
        Placement p = this.transform(exprs, op);
        if (this.isNoChange(p)) {
            x.add(TransformFilterPlacement.buildFilter(exprs, op));
        } else {
            Op op1 = TransformFilterPlacement.buildFilter(p);
            x.add(op1);
        }
    }

    public static class Placement {
        public final Op op;
        public final ExprList unplaced;

        public Placement(Op op, ExprList remaining) {
            this.op = op;
            this.unplaced = remaining;
        }

        public String toString() {
            return "" + this.op + " : " + this.unplaced;
        }

        public int hashCode() {
            return 31 * Lib.hashCodeObject((Object)this.op, (int)1) + Lib.hashCodeObject((Object)this.unplaced);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Placement other = (Placement)obj;
            return Objects.equals(this.op, other.op) && Objects.equals(this.unplaced, other.unplaced);
        }
    }
}

